/***************************************************************************
 *   SPDX-FileCopyrightText: 2024 Jeremy Whiting <jpwhiting@kde.org>
 *
 *   SPDX-License-Identifier: GPL-2.0-only OR GPL-3.0-only OR LicenseRef-KDE-Accepted-GPL
 ***************************************************************************/

/*
 * This file was generated by qdbusxml2cpp version 0.8
 * Source file was com.steampowered.Atomupd1.xml
 *
 * qdbusxml2cpp is Copyright (C) The Qt Company Ltd. and other contributors.
 *
 * This is an auto-generated file.
 * This file may have been hand-edited. Look for HAND-EDIT comments
 * before re-generating it.
 */

#ifndef ATOMUPD1_ADAPTOR_H
#define ATOMUPD1_ADAPTOR_H

#include "../dbushelpers.h"
#include <QtCore/QObject>
#include <QtCore/qcontainerfwd.h>
#include <QtDBus/QtDBus>

/*
 * Adaptor class for interface com.steampowered.Atomupd1
 */
class Atomupd1Adaptor : public QDBusAbstractAdaptor
{
    Q_OBJECT
    Q_CLASSINFO("D-Bus Interface", "com.steampowered.Atomupd1")
    Q_CLASSINFO("D-Bus Introspection",
                ""
                "  <interface name=\"com.steampowered.Atomupd1\">\n"
                "    <property access=\"read\" type=\"u\" name=\"Version\"/>\n"
                "    <property access=\"read\" type=\"d\" name=\"ProgressPercentage\">\n"
                "      <annotation value=\"true\" name=\"org.freedesktop.DBus.Property.EmitsChangedSignal\"/>\n"
                "    </property>\n"
                "    <property access=\"read\" type=\"t\" name=\"EstimatedCompletionTime\">\n"
                "      <annotation value=\"true\" name=\"org.freedesktop.DBus.Property.EmitsChangedSignal\"/>\n"
                "    </property>\n"
                "    <property access=\"read\" type=\"u\" name=\"UpdateStatus\">\n"
                "      <annotation value=\"true\" name=\"org.freedesktop.DBus.Property.EmitsChangedSignal\"/>\n"
                "    </property>\n"
                "    <property access=\"read\" type=\"s\" name=\"UpdateBuildID\"/>\n"
                "    <property access=\"read\" type=\"s\" name=\"UpdateVersion\"/>\n"
                "    <property access=\"read\" type=\"s\" name=\"Variant\">\n"
                "      <annotation value=\"true\" name=\"org.freedesktop.DBus.Property.EmitsChangedSignal\"/>\n"
                "    </property>\n"
                "    <property access=\"read\" type=\"s\" name=\"Branch\">\n"
                "      <annotation value=\"true\" name=\"org.freedesktop.DBus.Property.EmitsChangedSignal\"/>\n"
                "    </property>\n"
                "    <property access=\"read\" type=\"(si)\" name=\"HttpProxy\">\n"
                "      <annotation value=\"HTTPProxy\" name=\"org.qtproject.QtDBus.QtTypeName\"/>\n"
                "      <annotation value=\"true\" name=\"org.freedesktop.DBus.Property.EmitsChangedSignal\"/>\n"
                "    </property>\n"
                "    <property access=\"read\" type=\"s\" name=\"FailureCode\">\n"
                "      <annotation value=\"true\" name=\"org.freedesktop.DBus.Property.EmitsChangedSignal\"/>\n"
                "    </property>\n"
                "    <property access=\"read\" type=\"s\" name=\"FailureMessage\">\n"
                "      <annotation value=\"true\" name=\"org.freedesktop.DBus.Property.EmitsChangedSignal\"/>\n"
                "    </property>\n"
                "    <property access=\"read\" type=\"a{sa{sv}}\" name=\"UpdatesAvailable\">\n"
                "      <annotation value=\"VariantMapMap\" name=\"org.qtproject.QtDBus.QtTypeName\"/>\n"
                "    </property>\n"
                "    <property access=\"read\" type=\"a{sa{sv}}\" name=\"UpdatesAvailableLater\">\n"
                "      <annotation value=\"VariantMapMap\" name=\"org.qtproject.QtDBus.QtTypeName\"/>\n"
                "    </property>\n"
                "    <property access=\"read\" type=\"s\" name=\"CurrentVersion\"/>\n"
                "    <property access=\"read\" type=\"s\" name=\"CurrentBuildID\"/>\n"
                "    <property access=\"read\" type=\"as\" name=\"KnownVariants\"/>\n"
                "    <property access=\"read\" type=\"as\" name=\"KnownBranches\"/>\n"
                "    <method name=\"ReloadConfiguration\">\n"
                "      <arg direction=\"in\" type=\"a{sv}\" name=\"options\"/>\n"
                "      <annotation value=\"QVariantMap\" name=\"org.qtproject.QtDBus.QtTypeName.In0\"/>\n"
                "    </method>\n"
                "    <method name=\"SwitchToVariant\">\n"
                "      <arg direction=\"in\" type=\"s\" name=\"variant\"/>\n"
                "    </method>\n"
                "    <method name=\"SwitchToBranch\">\n"
                "      <arg direction=\"in\" type=\"s\" name=\"branch\"/>\n"
                "    </method>\n"
                "    <method name=\"CheckForUpdates\">\n"
                "      <arg direction=\"in\" type=\"a{sv}\" name=\"options\"/>\n"
                "      <arg direction=\"out\" type=\"a{sa{sv}}\" name=\"updates_available\"/>\n"
                "      <arg direction=\"out\" type=\"a{sa{sv}}\" name=\"updates_available_later\"/>\n"
                "      <annotation value=\"QVariantMap\" name=\"org.qtproject.QtDBus.QtTypeName.In0\"/>\n"
                "      <annotation value=\"VariantMapMap\" name=\"org.qtproject.QtDBus.QtTypeName.Out0\"/>\n"
                "      <annotation value=\"VariantMapMap\" name=\"org.qtproject.QtDBus.QtTypeName.Out1\"/>\n"
                "    </method>\n"
                "    <method name=\"StartUpdate\">\n"
                "      <arg direction=\"in\" type=\"s\" name=\"id\"/>\n"
                "    </method>\n"
                "    <method name=\"PauseUpdate\"/>\n"
                "    <method name=\"ResumeUpdate\"/>\n"
                "    <method name=\"CancelUpdate\"/>\n"
                "    <method name=\"EnableHttpProxy\">\n"
                "      <arg direction=\"in\" type=\"s\" name=\"address\"/>\n"
                "      <arg direction=\"in\" type=\"i\" name=\"port\"/>\n"
                "      <arg direction=\"in\" type=\"a{sv}\" name=\"options\"/>\n"
                "      <annotation value=\"QVariantMap\" name=\"org.qtproject.QtDBus.QtTypeName.In2\"/>\n"
                "    </method>\n"
                "    <method name=\"DisableHttpProxy\"/>\n"
                "  </interface>\n"
                "")
public:
    Atomupd1Adaptor(QObject *parent);
    ~Atomupd1Adaptor() override;

public: // PROPERTIES
    Q_PROPERTY(QString Branch READ branch)
    QString branch() const;

    Q_PROPERTY(QString CurrentBuildID READ currentBuildID)
    QString currentBuildID() const;

    Q_PROPERTY(QString CurrentVersion READ currentVersion)
    QString currentVersion() const;

    Q_PROPERTY(qulonglong EstimatedCompletionTime READ estimatedCompletionTime)
    qulonglong estimatedCompletionTime() const;

    Q_PROPERTY(QString FailureCode READ failureCode)
    QString failureCode() const;

    Q_PROPERTY(QString FailureMessage READ failureMessage)
    QString failureMessage() const;

    Q_PROPERTY(HTTPProxy HttpProxy READ httpProxy)
    HTTPProxy httpProxy() const;

    Q_PROPERTY(QStringList KnownBranches READ knownBranches)
    QStringList knownBranches() const;

    Q_PROPERTY(QStringList KnownVariants READ knownVariants)
    QStringList knownVariants() const;

    Q_PROPERTY(double ProgressPercentage READ progressPercentage)
    double progressPercentage() const;

    Q_PROPERTY(QString UpdateBuildID READ updateBuildID)
    QString updateBuildID() const;

    Q_PROPERTY(uint UpdateStatus READ updateStatus)
    uint updateStatus() const;

    Q_PROPERTY(QString UpdateVersion READ updateVersion)
    QString updateVersion() const;

    Q_PROPERTY(VariantMapMap UpdatesAvailable READ updatesAvailable)
    VariantMapMap updatesAvailable() const;

    Q_PROPERTY(VariantMapMap UpdatesAvailableLater READ updatesAvailableLater)
    VariantMapMap updatesAvailableLater() const;

    Q_PROPERTY(QString Variant READ variant)
    QString variant() const;

    Q_PROPERTY(uint Version READ version)
    uint version() const;

public Q_SLOTS: // METHODS
    void CancelUpdate();
    VariantMapMap CheckForUpdates(const QVariantMap &options, VariantMapMap &updates_available_later);
    void DisableHttpProxy();
    void EnableHttpProxy(const QString &address, int port, const QVariantMap &options);
    void PauseUpdate();
    void ReloadConfiguration(const QVariantMap &options);
    void ResumeUpdate();
    void StartUpdate(const QString &id);
    void SwitchToBranch(const QString &branch);
    void SwitchToVariant(const QString &variant);
Q_SIGNALS: // SIGNALS
};

#endif
