# vmod\_re2

## Varnish Module for access to the Google RE2 regular expression engine

### DESCRIPTION

Varnish Module (VMOD) for access to the Google RE2 regular expression
engine.

Varnish VCL uses the PCRE library (Perl Compatible Regular Expressions)
for its native regular expressions, which runs very efficiently for many
common uses of pattern matching in VCL, as attested by years of
successful use of PCRE with Varnish.

But for certain kinds of patterns, the worst-case running time of the
PCRE matcher is exponential in the length of the string to be matched.
The matcher uses backtracking, implemented with recursive calls to the
internal `match()` function. In principle there is no upper bound to the
possible depth of backtracking and recursion, except as imposed by the
`varnishd` runtime parameters `pcre_match_limit` and
`pcre_match_limit_recursion`; matches fail if either of these limits are
met. Stack overflow caused by deep backtracking has occasionally been
the subject of `varnishd` issues.

RE2 differs from PCRE in that it limits the syntax of patterns so that
they always specify a regular language in the formally strict sense.
Most notably, backreferences within a pattern are not permitted, for
example `(foo|bar)\1` to match `foofoo` and `barbar`, but not `foobar`
or `barfoo`. See the link in `SEE ALSO` for the specification of RE2
syntax.

This means that an RE2 matcher runs as a finite automaton, which
guarantees linear running time in the length of the matched string.
There is no backtracking, and hence no risk of deep recursion or stack
overflow.

The relative advantages and disadvantages of RE2 and PCRE is a broad
subject, beyond the scope of this manual. See the references in `SEE
ALSO` for more in-depth discussion.

### INSTALLATION

See [INSTALL.rst](INSTALL.rst) in the source repository.

### AUTHOR

  - Geoffrey Simmons \<<geoff@uplex.de>\>

UPLEX Nils Goroll Systemoptimierung

### SEE ALSO

  - varnishd(1)
  - vcl(7)
  - VMOD source repository:
    <https://code.uplex.de/uplex-varnish/libvmod-re2>
      - Gitlab mirror: <https://gitlab.com/uplex/varnish/libvmod-re2>
  - RE2 git repo: <https://github.com/google/re2>
  - RE2 syntax: <https://github.com/google/re2/wiki/Syntax>
  - "Implementing Regular Expressions": <https://swtch.com/~rsc/regexp/>
      - Series of articles motivating the design of RE2, with discussion
        of how RE2 compares with PCRE

### COPYRIGHT

    Copyright (c) 2016-2018 UPLEX Nils Goroll Systemoptimierung
    All rights reserved
    
    Author: Geoffrey Simmons <geoffrey.simmons@uplex.de>
    
    See LICENSE
