---
title: KeyCDN
date: 2020-04-10
description: 'Showcase: "Hugo has become an integral part of our stack."'
siteURL: https://www.keycdn.com
---

At KeyCDN one of our primary focuses is on performance. With speed being ingrained in our DNA we knew from the start that we must use a fast static website generator that could meet our requirements. When evaluating the right solution, Hugo met our requirements and we looked no further as it was the fastest and most flexible.

## Why we chose Hugo

Before our migration to Hugo our website was powered by a PHP-based website that had about 50 pages and a WordPress website that had over 500 posts between our blog and knowledge base. This became harder to maintain as time continued. We felt like we were losing the speed and flexibility that we require. To overcome this we knew we needed to convert our website to be static. This would allow our website to be faster and more secure as it could be delivered by all of our edge locations.

It wasn't an easy task at the beginning, however, after evaluating Hugo and benchmarking it we knew we had found the ideal solution. Hugo was by far the fastest setup and offered an intuitive way to build our entire website exactly as needed. The Go-based templates, shortcodes, and configuration options made it easy to build a complex website.

In the fall of 2018 we started the migration and within a couple short months we had built a custom static website with Hugo and migrated all content from our old systems. The simplicity and vast amount of functionality that Hugo offers made this process fast and left our entire team, including all of our writers and developers, happy with the migration. Since migrating to Hugo we haven't looked back. Hugo has become an integral part of our stack. We're grateful to all those who have contributed to make Hugo what it is today.

## Technical overview

Below is an overview of what we used with Hugo to build our website:

- [KeyCDN](https://www.keycdn.com) uses a custom theme and is our primary hub for all style sheets and JavaScript. Our other websites, like [KeyCDN Tools](https://tools.keycdn.com), only import the required style sheets and JavaScript.
- We use [Gulp](https://gulpjs.com) in our build process for many tasks, such as combining, versioning, and compressing our style sheets as well as our JavaScript.
- Our search is powered by a custom solution that we've built. It allows our pages, blog, and knowledge base to be searched. It uses [Axios](https://github.com/axios/axios) to send a `POST` request containing the search query. An index file in JSON generated by Hugo is searched and the results are then returned.
- Our commenting system is also powered by a custom solution that we've built. It uses Axios to send a `GET` request containing the slug to pull the comment thread and a `POST` request containing the name, email address, and comment when submitting a comment.
- Our contact form is a simple HTML form, which uses Axios as well.
- Our writers use shortcodes to enhance the capability of Markdown.
- Our entire website is delivered through KeyCDN using a Pull Zone, which means all of our edge locations are delivering our website.
