#[===[.rst:
BBuildEnvDebug
--------------

Internal module providing macros and functions for debugging.  It won't be included by BBuildEnv by default.

#]===]


if( NOT CMAKE_VERSION VERSION_LESS 3.10 )
  include_guard( GLOBAL )
endif()


function( bb_dump_cmake_system_info )
  message( STATUS "bb_dump_cmake_system_info() entering" )
  message( STATUS "CMAKE_COMMAND:               ${CMAKE_COMMAND}" )
  message( STATUS "CMAKE_VERSION:               ${CMAKE_VERSION}" )
  message( STATUS "CMAKE_ROOT:                  ${CMAKE_ROOT}" )
  message( STATUS "CMAKE_SOURCE_DIR:            ${CMAKE_SOURCE_DIR}" )
  message( STATUS "CMAKE_SIZEOF_VOID_P:         ${CMAKE_SIZEOF_VOID_P}" )
  
  if( MINGW )
    message( STATUS "MINGW:                     on" )
  endif()

  if( CMAKE_CROSSCOMPILING )
    message( STATUS "CMAKE_CROSSCOMPILING:      on" )
  endif()
  
  # target operating system: Linux, Windows, Darwin, Android
  message( STATUS "CMAKE_SYSTEM_NAME:           ${CMAKE_SYSTEM_NAME}" )
  message( STATUS "CMAKE_HOST_SYSTEM:           ${CMAKE_HOST_SYSTEM}" )
  message( STATUS "CMAKE_SYSTEM_VERSION:        ${CMAKE_SYSTEM_VERSION}" )
  
  # examples: x86_64 (ubuntu 16.04, macosx 10.12)
  #           AMD64 (windows 7 64-bit, -A x64, -A Win32)
  message( STATUS "CMAKE_SYSTEM_PROCESSOR:      ${CMAKE_SYSTEM_PROCESSOR}" )
  message( STATUS "CMAKE_HOST_SYSTEM_PROCESSOR: ${CMAKE_HOST_SYSTEM_PROCESSOR}" )
 
  if( CMAKE_HOST_APPLE )
    message( STATUS "CMAKE_HOST_APPLE:            on" )
  endif()
  if( CMAKE_HOST_UNIX )
    message( STATUS "CMAKE_HOST_UNIX:             on" )
  endif()
  if( CMAKE_HOST_WIN32 )
    message( STATUS "CMAKE_HOST_WIN32:            on" )
  endif()
  if( NOT CMAKE_VERSION VERSION_LESS 3.10.0 )
    cmake_host_system_information( RESULT os_name QUERY OS_NAME )
    cmake_host_system_information( RESULT os_release QUERY OS_RELEASE )
    cmake_host_system_information( RESULT os_version QUERY OS_VERSION )
    cmake_host_system_information( RESULT os_platform QUERY OS_PLATFORM )
    message( STATUS "OS_NAME:                     ${os_name}" )
    message( STATUS "OS_RELEASE:                  ${os_release}" )
    message( STATUS "OS_VERSION:                  ${os_version}" )
    message( STATUS "OS_PLATFORM:                 ${os_platform}" )
  endif()
  message( STATUS "CMAKE_PROGRAM_PATH:          ${CMAKE_PROGRAM_PATH}" )  
  message( STATUS "CMAKE_SYSTEM_PROGRAM_PATH:   ${CMAKE_SYSTEM_PROGRAM_PATH}" )
  message( STATUS "CMAKE_GENERATOR:             ${CMAKE_GENERATOR}" )
  message( STATUS "CMAKE_GENERATOR_PLATFORM:    ${CMAKE_GENERATOR_PLATFORM}" )
  
  if( CMAKE_CXX_COMPILER_LOADED )
    message( STATUS "CMAKE_CXX_COMPILER_LOADED:   on" )
  endif()
  # expected: GNU, Clang, AppleClang, MSVC,
  message( STATUS "CMAKE_CXX_COMPILER_ID:       ${CMAKE_CXX_COMPILER_ID}" )
  message( STATUS "CMAKE_CXX_COMPILER:          ${CMAKE_CXX_COMPILER}" )
  message( STATUS "CMAKE_CXX_COMPILER_VERSION:  ${CMAKE_CXX_COMPILER_VERSION}" )
  #message( STATUS "cxx compile features:        ${CMAKE_CXX_COMPILE_FEATURES}" )
  if( CMAKE_CXX_COMPILER_ARCHITECTURE_ID )
    # CMAKE_CXX_COMPILER_ARCHITECTURE_ID is defined but empty on Linux
    message( STATUS "CMAKE_CXX_COMPILER_ARCHITECTURE_ID:  ${CMAKE_CXX_COMPILER_ARCHITECTURE_ID}" )
  endif()
  if( MSVC )
    message( STATUS "CMAKE_VS_PLATFORM_NAME:      ${CMAKE_VS_PLATFORM_NAME}" )
    message( STATUS "CMAKE_VS_PLATFORM_NAME:      ${CMAKE_VS_PLATFORM_NAME}" )
    message( STATUS "CMAKE_VS_PLATFORM_TOOLSET:   ${CMAKE_VS_PLATFORM_TOOLSET}" )
    message( STATUS "MSVC_VERSION:                ${MSVC_VERSION}" )
    if( NOT CMAKE_VERSION VERSION_LESS 3.12.0 )
      message( STATUS "MSVC_TOOLSET_VERSION:        ${MSVC_TOOLSET_VERSION}" )
    endif()
    if( CMAKE_CSharp_COMPILER_WORKS )
      message( STATUS "CMAKE_CSharp_COMPILER_ID:      ${CMAKE_CSharp_COMPILER_ID}" )
      message( STATUS "CMAKE_CSharp_COMPILER:         ${CMAKE_CSharp_COMPILER}" )
      message( STATUS "CMAKE_CSharp_COMPILER_VERSION: ${CMAKE_CSharp_COMPILER_VERSION}" )
    endif()
  endif()
  if( XCODE )
    if( CMAKE_Swift_COMPILER_ID )
      message( STATUS "CMAKE_Swift_COMPILER_ID:      ${CMAKE_Swift_COMPILER_ID}" )
      message( STATUS "CMAKE_Swift_COMPILER:         ${CMAKE_Swift_COMPILER}" )
      message( STATUS "CMAKE_Swift_COMPILER_VERSION: ${CMAKE_Swift_COMPILER_VERSION}" )
    endif()  
  endif()
  get_property( _bb_generator_is_multi_config GLOBAL PROPERTY GENERATOR_IS_MULTI_CONFIG )
  if( _bb_generator_is_multi_config )
    message( STATUS "CMAKE_CONFIGURATION_TYPES:   ${CMAKE_CONFIGURATION_TYPES}" )
  else()
    message( STATUS "CMAKE_BUILD_TYPE:            ${CMAKE_BUILD_TYPE}" )
  endif()
  unset( _bb_generator_is_multi_config ) 
  
  message( STATUS "bb_system_info:              ${bb_system_info}" )
  bb_get_target_arch( _bb_value )
  message( STATUS "bb_get_target_arch:          ${_bb_value}" )
  bb_get_home_dir( _bb_value )
  message( STATUS "bb_get_home_dir:             ${_bb_value}" )
  
  if( CMAKE_HOST_WIN32 )
    bb_get_program_files_x86( _bb_value )
    message( STATUS "bb_get_program_files_x86:              ${_bb_value}" )
    bb_get_program_files( _bb_value )
    message( STATUS "bb_get_program_files:                  ${_bb_value}" )
    bb_get_program_data( _bb_value )
    message( STATUS "bb_get_program_data:                   ${_bb_value}" )
  endif()
  message( STATUS "bb_dump_cmake_system_info() leaving" )
endfunction( bb_dump_cmake_system_info )


function( bb_dump_target_properties target_ prop1_ )
  if( NOT TARGET ${target_} )
    message( WARNING "target ${target_} does not exist." )
    return()
  endif()
  set( _prop_list ${prop1_} )
  list( APPEND _prop_list ${ARGN} )
  list( LENGTH _prop_list _prop_list_len )
  message( STATUS "bb_dump_target_properties: len=${_prop_list_len} ${_prop_list}" )
  foreach( _prop ${_prop_list} )
    get_target_property( _prop_value ${target_} ${_prop} )
    if( _prop_value )
      message( STATUS "${target_}: ${_prop}=${_prop_value}" )
    endif()  
  endforeach()
  message( STATUS "bb_dump_target_properties: leaving" )
endfunction()

macro( bb_dump_imported_target_properties target_ )
  bb_dump_target_properties( ${target_} IMPORTED_LOCATION IMPORTED_IMPLIB INTERFACE_INCLUDE_DIRECTORIES INTERFACE_COMPILE_DEFINITIONS INTERFACE_LINK_LIBRARIES )
endmacro()
