
// copicat1_neg_table generated by DK/circ_table_gen.py -- do not modify manually

 // variables used
 // --sig_max  -1.500000
 // --table_div  24.120176
 // --table_op  0.050000

struct tablecopicat1_neg { // 1-dimensional function table
    float low;
    float high;
    float istep;
    int size;
    float data[];
};

template <int tab_size>
struct tablecopicat1_neg_imp {
    float low;
    float high;
    float istep;
    int size;
    float data[tab_size];
    operator tablecopicat1_neg&() const { return *(tablecopicat1_neg*)this; }
};

 static tablecopicat1_neg_imp<2048> copicat1_neg_table __rt_data = {
	0,0.674414,68.2333,2048, {
	0.000000000000,0.000724173087,0.001447728523,0.002170666820,0.002892988495,
	0.003614694060,0.004335784028,0.005056258914,0.005776119229,0.006495365485,
	0.007213998194,0.007932017867,0.008649425014,0.009366220147,0.010082403773,
	0.010797976404,0.011512938547,0.012227290711,0.012941033405,0.013654167135,
	0.014366692408,0.015078609732,0.015789919612,0.016500622554,0.017210719063,
	0.017920209644,0.018629094802,0.019337375040,0.020045050862,0.020752122771,
	0.021458591270,0.022164456860,0.022869720043,0.023574381321,0.024278441194,
	0.024981900163,0.025684758727,0.026387017387,0.027088676640,0.027789736987,
	0.028490198924,0.029190062949,0.029889329561,0.030587999254,0.031286072527,
	0.031983549875,0.032680431793,0.033376718776,0.034072411320,0.034767509917,
	0.035462015062,0.036155927249,0.036849246969,0.037541974716,0.038234110981,
	0.038925656257,0.039616611033,0.040306975801,0.040996751050,0.041685937271,
	0.042374534954,0.043062544586,0.043749966656,0.044436801653,0.045123050064,
	0.045808712376,0.046493789075,0.047178280649,0.047862187583,0.048545510362,
	0.049228249472,0.049910405396,0.050591978620,0.051272969626,0.051953378899,
	0.052633206920,0.053312454172,0.053991121138,0.054669208298,0.055346716134,
	0.056023645127,0.056699995756,0.057375768501,0.058050963843,0.058725582259,
	0.059399624228,0.060073090229,0.060745980739,0.061418296235,0.062090037194,
	0.062761204093,0.063431797407,0.064101817611,0.064771265182,0.065440140593,
	0.066108444319,0.066776176834,0.067443338611,0.068109930122,0.068775951841,
	0.069441404240,0.070106287790,0.070770602963,0.071434350229,0.072097530058,
	0.072760142921,0.073422189288,0.074083669627,0.074744584407,0.075404934097,
	0.076064719164,0.076723940075,0.077382597299,0.078040691300,0.078698222546,
	0.079355191503,0.080011598635,0.080667444408,0.081322729286,0.081977453733,
	0.082631618212,0.083285223188,0.083938269123,0.084590756479,0.085242685718,
	0.085894057302,0.086544871692,0.087195129348,0.087844830732,0.088493976303,
	0.089142566520,0.089790601842,0.090438082729,0.091085009638,0.091731383028,
	0.092377203355,0.093022471076,0.093667186649,0.094311350529,0.094954963173,
	0.095598025035,0.096240536570,0.096882498233,0.097523910478,0.098164773759,
	0.098805088529,0.099444855240,0.100084074346,0.100722746299,0.101360871549,
	0.101998450549,0.102635483748,0.103271971598,0.103907914549,0.104543313049,
	0.105178167549,0.105812478497,0.106446246341,0.107079471529,0.107712154509,
	0.108344295729,0.108975895634,0.109606954671,0.110237473285,0.110867451924,
	0.111496891031,0.112125791051,0.112754152429,0.113381975608,0.114009261033,
	0.114636009145,0.115262220388,0.115887895204,0.116513034036,0.117137637323,
	0.117761705508,0.118385239031,0.119008238332,0.119630703851,0.120252636029,
	0.120874035303,0.121494902112,0.122115236895,0.122735040089,0.123354312133,
	0.123973053462,0.124591264514,0.125208945726,0.125826097531,0.126442720368,
	0.127058814669,0.127674380871,0.128289419406,0.128903930710,0.129517915216,
	0.130131373356,0.130744305563,0.131356712270,0.131968593909,0.132579950911,
	0.133190783707,0.133801092727,0.134410878403,0.135020141164,0.135628881439,
	0.136237099658,0.136844796249,0.137451971642,0.138058626262,0.138664760539,
	0.139270374900,0.139875469771,0.140480045578,0.141084102748,0.141687641706,
	0.142290662877,0.142893166686,0.143495153558,0.144096623917,0.144697578185,
	0.145298016788,0.145897940146,0.146497348684,0.147096242822,0.147694622983,
	0.148292489588,0.148889843058,0.149486683813,0.150083012274,0.150678828860,
	0.151274133990,0.151868928085,0.152463211561,0.153056984838,0.153650248334,
	0.154243002465,0.154835247649,0.155426984303,0.156018212842,0.156608933683,
	0.157199147242,0.157788853932,0.158378054170,0.158966748370,0.159554936945,
	0.160142620309,0.160729798875,0.161316473057,0.161902643267,0.162488309916,
	0.163073473417,0.163658134180,0.164242292618,0.164825949139,0.165409104156,
	0.165991758077,0.166573911311,0.167155564268,0.167736717357,0.168317370986,
	0.168897525562,0.169477181494,0.170056339188,0.170634999052,0.171213161491,
	0.171790826912,0.172367995720,0.172944668321,0.173520845119,0.174096526519,
	0.174671712926,0.175246404743,0.175820602373,0.176394306220,0.176967516686,
	0.177540234173,0.178112459084,0.178684191820,0.179255432782,0.179826182370,
	0.180396440986,0.180966209030,0.181535486900,0.182104274997,0.182672573719,
	0.183240383466,0.183807704634,0.184374537622,0.184940882828,0.185506740648,
	0.186072111480,0.186636995719,0.187201393762,0.187765306004,0.188328732840,
	0.188891674666,0.189454131876,0.190016104864,0.190577594024,0.191138599749,
	0.191699122433,0.192259162467,0.192818720245,0.193377796158,0.193936390598,
	0.194494503957,0.195052136624,0.195609288991,0.196165961448,0.196722154384,
	0.197277868189,0.197833103251,0.198387859961,0.198942138705,0.199495939873,
	0.200049263850,0.200602111026,0.201154481786,0.201706376518,0.202257795606,
	0.202808739438,0.203359208398,0.203909202872,0.204458723245,0.205007769900,
	0.205556343222,0.206104443594,0.206652071400,0.207199227022,0.207745910844,
	0.208292123247,0.208837864613,0.209383135324,0.209927935761,0.210472266305,
	0.211016127336,0.211559519233,0.212102442378,0.212644897149,0.213186883926,
	0.213728403086,0.214269455008,0.214810040071,0.215350158652,0.215889811127,
	0.216428997875,0.216967719271,0.217505975691,0.218043767512,0.218581095110,
	0.219117958858,0.219654359132,0.220190296306,0.220725770755,0.221260782852,
	0.221795332970,0.222329421483,0.222863048763,0.223396215182,0.223928921113,
	0.224461166927,0.224992952996,0.225524279690,0.226055147379,0.226585556435,
	0.227115507227,0.227645000125,0.228174035497,0.228702613713,0.229230735141,
	0.229758400150,0.230285609106,0.230812362378,0.231338660333,0.231864503337,
	0.232389891757,0.232914825959,0.233439306309,0.233963333172,0.234486906913,
	0.235010027897,0.235532696489,0.236054913051,0.236576677949,0.237097991545,
	0.237618854202,0.238139266284,0.238659228151,0.239178740167,0.239697802693,
	0.240216416090,0.240734580719,0.241252296941,0.241769565117,0.242286385605,
	0.242802758766,0.243318684958,0.243834164542,0.244349197875,0.244863785315,
	0.245377927222,0.245891623951,0.246404875860,0.246917683307,0.247430046648,
	0.247941966239,0.248453442436,0.248964475594,0.249475066069,0.249985214215,
	0.250494920388,0.251004184941,0.251513008228,0.252021390604,0.252529332420,
	0.253036834030,0.253543895786,0.254050518041,0.254556701147,0.255062445455,
	0.255567751316,0.256072619081,0.256577049101,0.257081041726,0.257584597306,
	0.258087716190,0.258590398728,0.259092645268,0.259594456160,0.260095831751,
	0.260596772389,0.261097278422,0.261597350197,0.262096988062,0.262596192361,
	0.263094963443,0.263593301653,0.264091207336,0.264588680838,0.265085722503,
	0.265582332677,0.266078511704,0.266574259927,0.267069577691,0.267564465338,
	0.268058923212,0.268552951655,0.269046551009,0.269539721618,0.270032463822,
	0.270524777962,0.271016664381,0.271508123418,0.271999155414,0.272489760709,
	0.272979939644,0.273469692556,0.273959019786,0.274447921672,0.274936398553,
	0.275424450766,0.275912078651,0.276399282544,0.276886062782,0.277372419702,
	0.277858353641,0.278343864936,0.278828953921,0.279313620933,0.279797866307,
	0.280281690378,0.280765093481,0.281248075949,0.281730638117,0.282212780319,
	0.282694502887,0.283175806156,0.283656690457,0.284137156124,0.284617203488,
	0.285096832881,0.285576044634,0.286054839079,0.286533216547,0.287011177367,
	0.287488721871,0.287965850389,0.288442563249,0.288918860781,0.289394743314,
	0.289870211177,0.290345264697,0.290819904204,0.291294130025,0.291767942487,
	0.292241341917,0.292714328642,0.293186902988,0.293659065283,0.294130815850,
	0.294602155017,0.295073083108,0.295543600448,0.296013707362,0.296483404174,
	0.296952691208,0.297421568788,0.297890037236,0.298358096877,0.298825748033,
	0.299292991026,0.299759826179,0.300226253813,0.300692274249,0.301157887810,
	0.301623094816,0.302087895587,0.302552290444,0.303016279707,0.303479863695,
	0.303943042728,0.304405817126,0.304868187205,0.305330153286,0.305791715687,
	0.306252874724,0.306713630717,0.307173983981,0.307633934834,0.308093483593,
	0.308552630574,0.309011376093,0.309469720465,0.309927664006,0.310385207032,
	0.310842349857,0.311299092795,0.311755436162,0.312211380270,0.312666925433,
	0.313122071965,0.313576820179,0.314031170387,0.314485122903,0.314938678037,
	0.315391836102,0.315844597409,0.316296962270,0.316748930996,0.317200503897,
	0.317651681283,0.318102463465,0.318552850752,0.319002843454,0.319452441880,
	0.319901646338,0.320350457138,0.320798874588,0.321246898995,0.321694530667,
	0.322141769912,0.322588617036,0.323035072347,0.323481136151,0.323926808754,
	0.324372090462,0.324816981581,0.325261482415,0.325705593271,0.326149314453,
	0.326592646264,0.327035589010,0.327478142994,0.327920308520,0.328362085891,
	0.328803475410,0.329244477380,0.329685092102,0.330125319880,0.330565161015,
	0.331004615809,0.331443684562,0.331882367576,0.332320665151,0.332758577588,
	0.333196105187,0.333633248248,0.334070007069,0.334506381952,0.334942373193,
	0.335377981092,0.335813205948,0.336248048058,0.336682507720,0.337116585232,
	0.337550280890,0.337983594992,0.338416527835,0.338849079714,0.339281250927,
	0.339713041767,0.340144452532,0.340575483516,0.341006135015,0.341436407322,
	0.341866300733,0.342295815540,0.342724952039,0.343153710523,0.343582091284,
	0.344010094616,0.344437720811,0.344864970162,0.345291842962,0.345718339500,
	0.346144460070,0.346570204963,0.346995574469,0.347420568879,0.347845188484,
	0.348269433573,0.348693304437,0.349116801365,0.349539924647,0.349962674571,
	0.350385051426,0.350807055501,0.351228687083,0.351649946461,0.352070833923,
	0.352491349755,0.352911494244,0.353331267679,0.353750670344,0.354169702526,
	0.354588364512,0.355006656587,0.355424579035,0.355842132144,0.356259316196,
	0.356676131477,0.357092578272,0.357508656863,0.357924367536,0.358339710573,
	0.358754686257,0.359169294872,0.359583536700,0.359997412024,0.360410921125,
	0.360824064286,0.361236841788,0.361649253913,0.362061300940,0.362472983152,
	0.362884300829,0.363295254250,0.363705843696,0.364116069447,0.364525931781,
	0.364935430978,0.365344567317,0.365753341076,0.366161752534,0.366569801969,
	0.366977489658,0.367384815879,0.367791780909,0.368198385025,0.368604628505,
	0.369010511623,0.369416034657,0.369821197883,0.370226001575,0.370630446010,
	0.371034531462,0.371438258206,0.371841626517,0.372244636669,0.372647288936,
	0.373049583592,0.373451520911,0.373853101165,0.374254324627,0.374655191571,
	0.375055702269,0.375455856992,0.375855656013,0.376255099603,0.376654188034,
	0.377052921577,0.377451300503,0.377849325082,0.378246995585,0.378644312281,
	0.379041275441,0.379437885333,0.379834142229,0.380230046395,0.380625598101,
	0.381020797616,0.381415645208,0.381810141144,0.382204285693,0.382598079122,
	0.382991521697,0.383384613687,0.383777355357,0.384169746975,0.384561788805,
	0.384953481115,0.385344824170,0.385735818234,0.386126463574,0.386516760453,
	0.386906709138,0.387296309891,0.387685562978,0.388074468661,0.388463027205,
	0.388851238873,0.389239103927,0.389626622631,0.390013795247,0.390400622038,
	0.390787103265,0.391173239190,0.391559030076,0.391944476182,0.392329577770,
	0.392714335101,0.393098748435,0.393482818033,0.393866544155,0.394249927060,
	0.394632967007,0.395015664257,0.395398019067,0.395780031697,0.396161702406,
	0.396543031451,0.396924019090,0.397304665581,0.397684971182,0.398064936150,
	0.398444560741,0.398823845213,0.399202789822,0.399581394824,0.399959660475,
	0.400337587031,0.400715174747,0.401092423878,0.401469334680,0.401845907408,
	0.402222142315,0.402598039655,0.402973599684,0.403348822654,0.403723708819,
	0.404098258432,0.404472471747,0.404846349016,0.405219890490,0.405593096424,
	0.405965967068,0.406338502675,0.406710703495,0.407082569781,0.407454101783,
	0.407825299752,0.408196163938,0.408566694592,0.408936891963,0.409306756302,
	0.409676287858,0.410045486880,0.410414353618,0.410782888320,0.411151091234,
	0.411518962610,0.411886502694,0.412253711736,0.412620589982,0.412987137680,
	0.413353355076,0.413719242419,0.414084799954,0.414450027928,0.414814926586,
	0.415179496176,0.415543736942,0.415907649130,0.416271232984,0.416634488751,
	0.416997416675,0.417360016999,0.417722289969,0.418084235828,0.418445854820,
	0.418807147189,0.419168113177,0.419528753028,0.419889066985,0.420249055289,
	0.420608718184,0.420968055912,0.421327068713,0.421685756831,0.422044120505,
	0.422402159978,0.422759875490,0.423117267282,0.423474335594,0.423831080666,
	0.424187502738,0.424543602051,0.424899378843,0.425254833353,0.425609965821,
	0.425964776486,0.426319265585,0.426673433357,0.427027280041,0.427380805874,
	0.427734011093,0.428086895936,0.428439460640,0.428791705442,0.429143630579,
	0.429495236287,0.429846522801,0.430197490359,0.430548139196,0.430898469547,
	0.431248481647,0.431598175732,0.431947552036,0.432296610795,0.432645352241,
	0.432993776610,0.433341884135,0.433689675050,0.434037149587,0.434384307982,
	0.434731150465,0.435077677271,0.435423888631,0.435769784778,0.436115365944,
	0.436460632360,0.436805584259,0.437150221870,0.437494545427,0.437838555159,
	0.438182251297,0.438525634072,0.438868703713,0.439211460452,0.439553904516,
	0.439896036137,0.440237855543,0.440579362963,0.440920558627,0.441261442762,
	0.441602015598,0.441942277362,0.442282228282,0.442621868586,0.442961198502,
	0.443300218257,0.443638928077,0.443977328190,0.444315418822,0.444653200200,
	0.444990672549,0.445327836096,0.445664691067,0.446001237686,0.446337476179,
	0.446673406771,0.447009029687,0.447344345152,0.447679353389,0.448014054624,
	0.448348449079,0.448682536979,0.449016318547,0.449349794006,0.449682963579,
	0.450015827490,0.450348385960,0.450680639212,0.451012587469,0.451344230951,
	0.451675569882,0.452006604482,0.452337334972,0.452667761575,0.452997884509,
	0.453327703997,0.453657220258,0.453986433513,0.454315343982,0.454643951884,
	0.454972257439,0.455300260866,0.455627962384,0.455955362213,0.456282460570,
	0.456609257675,0.456935753745,0.457261948998,0.457587843653,0.457913437927,
	0.458238732036,0.458563726200,0.458888420633,0.459212815553,0.459536911177,
	0.459860707720,0.460184205399,0.460507404430,0.460830305028,0.461152907409,
	0.461475211787,0.461797218379,0.462118927398,0.462440339059,0.462761453577,
	0.463082271166,0.463402792039,0.463723016410,0.464042944494,0.464362576502,
	0.464681912649,0.465000953147,0.465319698208,0.465638148046,0.465956302872,
	0.466274162898,0.466591728337,0.466908999399,0.467225976297,0.467542659241,
	0.467859048442,0.468175144112,0.468490946460,0.468806455697,0.469121672034,
	0.469436595679,0.469751226843,0.470065565735,0.470379612565,0.470693367541,
	0.471006830873,0.471320002769,0.471632883438,0.471945473087,0.472257771926,
	0.472569780161,0.472881498000,0.473192925652,0.473504063322,0.473814911219,
	0.474125469548,0.474435738516,0.474745718331,0.475055409197,0.475364811322,
	0.475673924910,0.475982750167,0.476291287299,0.476599536511,0.476907498008,
	0.477215171994,0.477522558674,0.477829658253,0.478136470934,0.478442996922,
	0.478749236420,0.479055189632,0.479360856761,0.479666238009,0.479971333582,
	0.480276143679,0.480580668505,0.480884908262,0.481188863152,0.481492533376,
	0.481795919136,0.482099020635,0.482401838072,0.482704371650,0.483006621568,
	0.483308588029,0.483610271232,0.483911671377,0.484212788665,0.484513623296,
	0.484814175469,0.485114445384,0.485414433240,0.485714139236,0.486013563571,
	0.486312706444,0.486611568053,0.486910148596,0.487208448273,0.487506467280,
	0.487804205815,0.488101664076,0.488398842259,0.488695740564,0.488992359185,
	0.489288698320,0.489584758165,0.489880538917,0.490176040772,0.490471263925,
	0.490766208573,0.491060874910,0.491355263133,0.491649373437,0.491943206016,
	0.492236761064,0.492530038778,0.492823039351,0.493115762977,0.493408209850,
	0.493700380163,0.493992274112,0.494283891888,0.494575233686,0.494866299697,
	0.495157090116,0.495447605134,0.495737844944,0.496027809738,0.496317499708,
	0.496606915047,0.496896055945,0.497184922594,0.497473515185,0.497761833910,
	0.498049878960,0.498337650524,0.498625148794,0.498912373959,0.499199326211,
	0.499486005738,0.499772412731,0.500058547379,0.500344409872,0.500630000398,
	0.500915319146,0.501200366306,0.501485142066,0.501769646614,0.502053880139,
	0.502337842828,0.502621534869,0.502904956451,0.503188107760,0.503470988983,
	0.503753600309,0.504035941923,0.504318014012,0.504599816764,0.504881350363,
	0.505162614997,0.505443610851,0.505724338110,0.506004796962,0.506284987590,
	0.506564910181,0.506844564918,0.507123951988,0.507403071574,0.507681923861,
	0.507960509034,0.508238827276,0.508516878771,0.508794663703,0.509072182255,
	0.509349434612,0.509626420955,0.509903141468,0.510179596334,0.510455785735,
	0.510731709854,0.511007368873,0.511282762974,0.511557892338,0.511832757148,
	0.512107357585,0.512381693831,0.512655766065,0.512929574470,0.513203119226,
	0.513476400514,0.513749418514,0.514022173406,0.514294665371,0.514566894587,
	0.514838861235,0.515110565495,0.515382007545,0.515653187565,0.515924105734,
	0.516194762229,0.516465157231,0.516735290917,0.517005163466,0.517274775055,
	0.517544125863,0.517813216067,0.518082045844,0.518350615373,0.518618924829,
	0.518886974391,0.519154764234,0.519422294535,0.519689565472,0.519956577219,
	0.520223329953,0.520489823851,0.520756059087,0.521022035837,0.521287754276,
	0.521553214581,0.521818416924,0.522083361483,0.522348048430,0.522612477941,
	0.522876650190,0.523140565351,0.523404223598,0.523667625104,0.523930770044,
	0.524193658590,0.524456290916,0.524718667194,0.524980787599,0.525242652301,
	0.525504261475,0.525765615292,0.526026713924,0.526287557544,0.526548146323,
	0.526808480433,0.527068560045,0.527328385331,0.527587956461,0.527847273607,
	0.528106336940,0.528365146630,0.528623702847,0.528882005762,0.529140055544,
	0.529397852365,0.529655396393,0.529912687797,0.530169726748,0.530426513415,
	0.530683047966,0.530939330571,0.531195361398,0.531451140616,0.531706668393,
	0.531961944896,0.532216970296,0.532471744758,0.532726268451,0.532980541542,
	0.533234564199,0.533488336588,0.533741858877,0.533995131233,0.534248153822,
	0.534500926810,0.534753450365,0.535005724651,0.535257749835,0.535509526083,
	0.535761053561,0.536012332434,0.536263362866,0.536514145024,0.536764679072,
	0.537014965176,0.537265003499,0.537514794205,0.537764337461,0.538013633428,
	0.538262682273,0.538511484157,0.538760039245,0.539008347700,0.539256409686,
	0.539504225365,0.539751794901,0.539999118456,0.540246196193,0.540493028275,
	0.540739614862,0.540985956119,0.541232052206,0.541477903286,0.541723509520,
	0.541968871069,0.542213988095,0.542458860759,0.542703489221,0.542947873644,
	0.543192014186,0.543435911009,0.543679564273,0.543922974138,0.544166140764,
	0.544409064311,0.544651744938,0.544894182805,0.545136378071,0.545378330896,
	0.545620041438,0.545861509856,0.546102736309,0.546343720956,0.546584463954,
	0.546824965461,0.547065225637,0.547305244638,0.547545022622,0.547784559747,
	0.548023856171,0.548262912049,0.548501727540,0.548740302801,0.548978637987,
	0.549216733256,0.549454588763,0.549692204666,0.549929581120,0.550166718281,
	0.550403616305,0.550640275347,0.550876695563,0.551112877108,0.551348820138,
	0.551584524806,0.551819991268,0.552055219679,0.552290210193,0.552524962965,
	0.552759478147,0.552993755896,0.553227796363,0.553461599704,0.553695166071,
	0.553928495617,0.554161588497,0.554394444863,0.554627064868,0.554859448664,
	0.555091596405,0.555323508242,0.555555184329,0.555786624816,0.556017829856,
	0.556248799601,0.556479534202,0.556710033812,0.556940298580,0.557170328658,
	0.557400124198,0.557629685350,0.557859012265,0.558088105093,0.558316963985,
	0.558545589091,0.558773980560,0.559002138544,0.559230063192,0.559457754652,
	0.559685213076,0.559912438612,0.560139431408,0.560366191615,0.560592719381,
	0.560819014855,0.561045078184,0.561270909519,0.561496509006,0.561721876794,
	0.561947013030,0.562171917864,0.562396591441,0.562621033910,0.562845245418,
	0.563069226112,0.563292976138,0.563516495645,0.563739784778,0.563962843684,
	0.564185672510,0.564408271402,0.564630640505,0.564852779966,0.565074689930,
	0.565296370544,0.565517821952,0.565739044300,0.565960037733,0.566180802396,
	0.566401338435,0.566621645993,0.566841725215,0.567061576246,0.567281199230,
	0.567500594311,0.567719761633,0.567938701341,0.568157413576,0.568375898484,
	0.568594156208,0.568812186890,0.569029990674,0.569247567703,0.569464918119,
	0.569682042065,0.569898939684,0.570115611118,0.570332056510,0.570548276000,
	0.570764269732,0.570980037846,0.571195580485,0.571410897790,0.571625989902,
	0.571840856963,0.572055499112,0.572269916493,0.572484109244,0.572698077506,
	0.572911821421,0.573125341128,0.573338636767,0.573551708479,0.573764556403,
	0.573977180678,0.574189581446,0.574401758844,0.574613713012,0.574825444089,
	0.575036952215,0.575248237528,0.575459300166,0.575670140269,0.575880757974,
	0.576091153420,0.576301326745,0.576511278087,0.576721007584,0.576930515373,
	0.577139801593,0.577348866379,0.577557709870,0.577766332203,0.577974733514,
	0.578182913941,0.578390873619,0.578598612687,0.578806131279,0.579013429533,
	0.579220507584,0.579427365568,0.579634003621,0.579840421879,0.580046620477,
	0.580252599551,0.580458359236,0.580663899667,0.580869220978,0.581074323306,
	0.581279206784,0.581483871547,0.581688317729,0.581892545465,0.582096554889,
	0.582300346135,0.582503919336,0.582707274626,0.582910412139,0.583113332009,
	0.583316034368,0.583518519349,0.583720787086,0.583922837712,0.584124671359,
	0.584326288159,0.584527688246,0.584728871752,0.584929838808,0.585130589546,
	0.585331124099,0.585531442599,0.585731545177,0.585931431963,0.586131103091,
	0.586330558690,0.586529798893,0.586728823829,0.586927633630,0.587126228426,
	0.587324608348,0.587522773527,0.587720724091,0.587918460172,0.588115981900,
	0.588313289403,0.588510382813,0.588707262258,0.588903927868,0.589100379773,
	0.589296618100,0.589492642980,0.589688454541,0.589884052912,0.590079438221,
	0.590274610597,0.590469570169,0.590664317064,0.590858851410,0.591053173336,
	0.591247282969,0.591441180437,0.591634865868,0.591828339388,0.592021601125,
	0.592214651206,0.592407489758,0.592600116909,0.592792532783,0.592984737509,
	0.593176731213,0.593368514021,0.593560086058,0.593751447452,0.593942598328,
	0.594133538812,0.594324269029,0.594514789106,0.594705099166,0.594895199337,
	0.595085089742,0.595274770506,0.595464241756,0.595653503614,0.595842556207,
	0.596031399658,0.596220034091,0.596408459631,0.596596676402,0.596784684528,
	0.596972484133,0.597160075340,0.597347458272,0.597534633054,0.597721599808,
	0.597908358658,0.598094909727,0.598281253137,0.598467389011,0.598653317472,
	0.598839038642,0.599024552644,0.599209859601,0.599394959633,0.599579852863,
	0.599764539413,0.599949019405,0.600133292960,0.600317360199,0.600501221244,
	0.600684876217,0.600868325238,0.601051568427,0.601234605907,0.601417437798,
	0.601600064219,0.601782485292,0.601964701138,0.602146711875,0.602328517624,
	0.602510118506,0.602691514639,0.602872706144,0.603053693140,0.603234475746,
	0.603415054082,0.603595428267,0.603775598419,0.603955564659,0.604135327104,
	0.604314885873,0.604494241085,0.604673392858,0.604852341311,0.605031086561,
	0.605209628727,0.605387967926,0.605566104276,0.605744037895,0.605921768901,
	0.606099297410,0.606276623540,0.606453747408,0.606630669132,0.606807388827,
	0.606983906612,0.607160222602,0.607336336913,0.607512249664,0.607687960968,
	0.607863470944,0.608038779706,0.608213887371,0.608388794055,0.608563499872,
	0.608738004939,0.608912309372,0.609086413284,0.609260316792,0.609434020010,
	0.609607523054,0.609780826038,0.609953929077,0.610126832285,0.610299535777,
	0.610472039667,0.610644344069,0.610816449098,0.610988354867,0.611160061490,
	0.611331569080,0.611502877752,0.611673987619,0.611844898794,0.612015611390,
	0.612186125520,0.612356441297,0.612526558835,0.612696478245,0.612866199641,
	0.613035723135,0.613205048839,0.613374176865,0.613543107326,0.613711840334,
	0.613880376000,0.614048714436,0.614216855755,0.614384800066,0.614552547482,
	0.614720098114,0.614887452074,0.615054609471,0.615221570418,0.615388335024,
	0.615554903401,0.615721275660,0.615887451909,0.616053432261,0.616219216825,
	0.616384805711,0.616550199029,0.616715396889,0.616880399400,0.617045206673,
	0.617209818817,0.617374235941,0.617538458154,0.617702485566,0.617866318286,
	0.618029956422,0.618193400083,0.618356649378,0.618519704416,0.618682565305,
	0.618845232153,0.619007705068,0.619169984159,0.619332069534,0.619493961299,
	0.619655659564,0.619817164436,0.619978476022,0.620139594429,0.620300519766,
	0.620461252138,0.620621791653,0.620782138419,0.620942292541,0.621102254127,
	0.621262023283,0.621421600115,0.621580984730,0.621740177235,0.621899177734,
	0.622057986335,0.622216603143,0.622375028264,0.622533261804,0.622691303867,
	0.622849154561,0.623006813989,0.623164282257,0.623321559470,0.623478645734,
	0.623635541153,0.623792245831,0.623948759874,0.624105083385,0.624261216470,
	0.624417159233,0.624572911778,0.624728474208,0.624883846628,0.625039029142,
	0.625194021854,0.625348824866,0.625503438284,0.625657862209,0.625812096745,
	0.625966141996,0.626119998064,0.626273665053,0.626427143065,0.626580432203,
	0.626733532569,0.626886444267,0.627039167398,0.627191702066,0.627344048371,
	0.627496206416,0.627648176303,0.627799958134,0.627951552010,0.628102958034,
	0.628254176306,0.628405206929,0.628556050003,0.628706705629,0.628857173909,
	0.629007454943,0.629157548833,0.629307455679,0.629457175582,0.629606708642,
	0.629756054960,0.629905214636,0.630054187770,0.630202974462,0.630351574813,
	0.630499988921,0.630648216888,0.630796258812,0.630944114793,0.631091784930,
	0.631239269324,0.631386568072,0.631533681275,0.631680609030,0.631827351438,
	0.631973908596,0.632120280604,0.632266467560,0.632412469562,0.632558286709,
	0.632703919099,0.632849366831,0.632994630001,0.633139708709,0.633284603052,
	0.633429313128,0.633573839033,0.633718180867,0.633862338726,0.634006312707,
	0.634150102908,0.634293709425,0.634437132356,0.634580371798,0.634723427847,
	0.634866300600,0.635008990154,0.635151496604,0.635293820048,0.635435960581,
	0.635577918299,0.635719693299,0.635861285677,0.636002695528,0.636143922948,
	0.636284968033,0.636425830877,0.636566511578,0.636707010229,0.636847326926,
	0.636987461763,0.637127414837,0.637267186242,0.637406776072,0.637546184423,
	0.637685411388,0.637824457063,0.637963321541,0.638102004918,0.638240507286,
	0.638378828740,0.638516969374,0.638654929282,0.638792708557,0.638930307294,
	0.639067725585,0.639204963525,0.639342021205,0.639478898721,0.639615596164,
	0.639752113628,0.639888451205,0.640024608989,0.640160587072,0.640296385547,
	0.640432004506,0.640567444042,0.640702704246,0.640837785212,0.640972687031,
	0.641107409796,0.641241953597,0.641376318527,0.641510504678,0.641644512141,
	0.641778341008,0.641911991370,0.642045463318,0.642178756944,0.642311872338,
	0.642444809592,0.642577568796,0.642710150042,0.642842553420,0.642974779020,
	0.643106826933,0.643238697250,0.643370390061,0.643501905455,0.643633243523,
	0.643764404355,0.643895388041,0.644026194671,0.644156824334,0.644287277120,
	0.644417553119,0.644547652419,0.644677575111,0.644807321282,0.644936891023,
	0.645066284423,0.645195501570,0.645324542553,0.645453407461,0.645582096382,
	0.645710609405,0.645838946619,0.645967108111,0.646095093970,0.646222904285,
	0.646350539142,0.646477998630,0.646605282837,0.646732391851,0.646859325758,
	0.646986084648,0.647112668606,0.647239077721,0.647365312080,0.647491371770,
	0.647617256878,0.647742967490,0.647868503694,0.647993865577,0.648119053225,
	0.648244066725,0.648368906163,0.648493571626,0.648618063199,0.648742380970,
	0.648866525024,0.648990495447,0.649114292326,0.649237915745,0.649361365791,
	0.649484642549,0.649607746105,0.649730676544,0.649853433952,0.649976018414,
	0.650098430015,0.650220668839,0.650342734973,0.650464628500,0.650586349506,
	0.650707898075,0.650829274293,0.650950478242,0.651071510008,0.651192369676,
	0.651313057328,0.651433573050,0.651553916926,0.651674089039,0.651794089473,
	0.651913918311,0.652033575639,0.652153061538,0.652272376093,0.652391519387,
	0.652510491504,0.652629292525,0.652747922535,0.652866381617,0.652984669853,
	0.653102787327,0.653220734120,0.653338510316,0.653456115997,0.653573551245,
	0.653690816144,0.653807910775,0.653924835220,0.654041589561,0.654158173882,
	0.654274588262,0.654390832785,0.654506907531,0.654622812583,0.654738548022,
	0.654854113930,0.654969510387,0.655084737476,0.655199795277,0.655314683871,
	0.655429403339,0.655543953763,0.655658335223,0.655772547800,0.655886591574,
	0.656000466627,0.656114173037,0.656227710887,0.656341080256,0.656454281224,
	0.656567313871,0.656680178277,0.656792874523,0.656905402689,0.657017762853,
	0.657129955095,0.657241979496,0.657353836134,0.657465525089,0.657577046440,
	0.657688400267,0.657799586649,0.657910605664,0.658021457391,0.658132141910,
	0.658242659300,0.658353009638,0.658463193003,0.658573209475,0.658683059130,
	0.658792742049,0.658902258308,0.659011607987,0.659120791163,0.659229807914,
	0.659338658318,0.659447342452,0.659555860396,0.659664212225,0.659772398019,
	0.659880417853,0.659988271806,0.660095959955,0.660203482378,0.660310839150,
	0.660418030349,0.660525056053,0.660631916338,0.660738611280,0.660845140957,
	0.660951505445,0.661057704821,0.661163739160,0.661269608540,0.661375313037,
	0.661480852726,0.661586227685,0.661691437988,0.661796483712,0.661901364932,
	0.662006081725,0.662110634166,0.662215022331,0.662319246295,0.662423306133,
	0.662527201921,0.662630933734,0.662734501648,0.662837905737,0.662941146076,
	0.663044222740,0.663147135804,0.663249885344,0.663352471432,0.663454894145,
	0.663557153556,0.663659249740,0.663761182771,0.663862952723,0.663964559672,
	0.664066003689,0.664167284851,0.664268403230,0.664369358901,0.664470151936,
	0.664570782411,0.664671250397,0.664771555970,0.664871699202,0.664971680167,
	0.665071498937,0.665171155586,0.665270650188,0.665369982814,0.665469153539,
	0.665568162435,0.665667009574,0.665765695029,0.665864218873,0.665962581179,
	0.666060782018,0.666158821464,0.666256699588,0.666354416463,0.666451972160,
	0.666549366753,0.666646600312,0.666743672909,0.666840584617,0.666937335507,
	0.667033925651,0.667130355120,0.667226623985,0.667322732319,0.667418680192,
	0.667514467676,0.667610094841,0.667705561760,0.667800868502,0.667896015139,
	0.667991001741,0.668085828380,0.668180495125,0.668275002048,0.668369349220,
	0.668463536709,0.668557564588,0.668651432926,0.668745141793,0.668838691259,
	0.668932081395,0.669025312270,0.669118383955,0.669211296518,0.669304050031,
	0.669396644562,0.669489080181,0.669581356958,0.669673474961,0.669765434261,
	0.669857234926,0.669948877026,0.670040360630,0.670131685807,0.670222852626,
	0.670313861155,0.670404711463,0.670495403620,0.670585937694,0.670676313753,
	0.670766531866,0.670856592101,0.670946494527,0.671036239211,0.671125826223,
	0.671215255630,0.671304527500,0.671393641901,0.671482598901,0.671571398568,
	0.671660040969,0.671748526173,0.671836854246,0.671925025256,0.672013039272,
	0.672100896359,0.672188596585,0.672276140018,0.672363526725,0.672450756772,
	0.672537830226,0.672624747156,0.672711507626,0.672798111705,0.672884559458,
	0.672970850952,0.673056986255,0.673142965431,0.673228788549,0.673314455673,
	0.673399966871,0.673485322207,0.673570521750,0.673655565563,0.673740453714,
	0.673825186268,0.673909763291,0.673994184849,0.674078451007,0.674162561831,
	0.674246517387,0.674330317739,0.674413962953
	}
};

double always_inline copicat1_negclip(double x) {
    double f = fabs(x);
    f = f * copicat1_neg_table.istep;
    int i = static_cast<int>(f);
    if (i < 0) {
        f = copicat1_neg_table.data[0];
    } else if (i >= copicat1_neg_table.size-1) {
        f = copicat1_neg_table.data[copicat1_neg_table.size-1];
    } else {
    f -= i;
    f = copicat1_neg_table.data[i]*(1-f) + copicat1_neg_table.data[i+1]*f;
    }
    return copysign(f, x);
}

