/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crimson.tree;

import java.io.IOException;
import java.io.Writer;
import org.apache.crimson.tree.DomEx;
import org.apache.crimson.tree.NodeBase;
import org.apache.crimson.tree.XmlDocument;
import org.apache.crimson.tree.XmlWriteContext;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;

final class PINode
extends NodeBase
implements ProcessingInstruction {
    private String target;
    private char[] data;

    public PINode() {
    }

    public PINode(String target, String text) {
        this.data = text.toCharArray();
        this.target = target;
    }

    PINode(String target, char[] buf, int offset, int len) {
        this.data = new char[len];
        System.arraycopy(buf, offset, this.data, 0, len);
        this.target = target;
    }

    public short getNodeType() {
        return 7;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public String getData() {
        return new String(this.data);
    }

    public void setData(String data) {
        if (this.isReadonly()) {
            throw new DomEx(7);
        }
        this.data = data.toCharArray();
    }

    public String getNodeValue() {
        return this.getData();
    }

    public void setNodeValue(String data) {
        this.setData(data);
    }

    public void writeXml(XmlWriteContext context) throws IOException {
        Writer out = context.getWriter();
        out.write("<?");
        out.write(this.target);
        if (this.data != null) {
            out.write(32);
            out.write(this.data);
        }
        out.write("?>");
    }

    public Node cloneNode(boolean deep) {
        PINode retval = new PINode(this.target, this.data, 0, this.data.length);
        retval.setOwnerDocument((XmlDocument)this.getOwnerDocument());
        return retval;
    }

    public String getNodeName() {
        return this.target;
    }
}

