/*****************************************************************************
*
* Copyright (c) 2000 - 2010, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-400124
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <AxisTitles.h>
#include <DataNode.h>

// Type map format string
const char *AxisTitles::TypeMapFormatString = "babbss";

// ****************************************************************************
// Method: AxisTitles::AxisTitles
//
// Purpose: 
//   Constructor for the AxisTitles class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AxisTitles::AxisTitles() : 
    AttributeSubject(AxisTitles::TypeMapFormatString)
{
    visible = true;
    userTitle = false;
    userUnits = false;
}

// ****************************************************************************
// Method: AxisTitles::AxisTitles
//
// Purpose: 
//   Copy constructor for the AxisTitles class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AxisTitles::AxisTitles(const AxisTitles &obj) : 
    AttributeSubject(AxisTitles::TypeMapFormatString)
{
    visible = obj.visible;
    font = obj.font;
    userTitle = obj.userTitle;
    userUnits = obj.userUnits;
    title = obj.title;
    units = obj.units;

    SelectAll();
}

// ****************************************************************************
// Method: AxisTitles::~AxisTitles
//
// Purpose: 
//   Destructor for the AxisTitles class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AxisTitles::~AxisTitles()
{
    // nothing here
}

// ****************************************************************************
// Method: AxisTitles::operator = 
//
// Purpose: 
//   Assignment operator for the AxisTitles class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AxisTitles& 
AxisTitles::operator = (const AxisTitles &obj)
{
    if (this == &obj) return *this;
    visible = obj.visible;
    font = obj.font;
    userTitle = obj.userTitle;
    userUnits = obj.userUnits;
    title = obj.title;
    units = obj.units;

    SelectAll();
    return *this;
}

// ****************************************************************************
// Method: AxisTitles::operator == 
//
// Purpose: 
//   Comparison operator == for the AxisTitles class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
AxisTitles::operator == (const AxisTitles &obj) const
{
    // Create the return value
    return ((visible == obj.visible) &&
            (font == obj.font) &&
            (userTitle == obj.userTitle) &&
            (userUnits == obj.userUnits) &&
            (title == obj.title) &&
            (units == obj.units));
}

// ****************************************************************************
// Method: AxisTitles::operator != 
//
// Purpose: 
//   Comparison operator != for the AxisTitles class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
AxisTitles::operator != (const AxisTitles &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: AxisTitles::TypeName
//
// Purpose: 
//   Type name method for the AxisTitles class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

const std::string
AxisTitles::TypeName() const
{
    return "AxisTitles";
}

// ****************************************************************************
// Method: AxisTitles::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the AxisTitles class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
AxisTitles::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const AxisTitles *tmp = (const AxisTitles *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: AxisTitles::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the AxisTitles class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
AxisTitles::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new AxisTitles(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: AxisTitles::NewInstance
//
// Purpose: 
//   NewInstance method for the AxisTitles class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
AxisTitles::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new AxisTitles(*this);
    else
        retval = new AxisTitles;

    return retval;
}

// ****************************************************************************
// Method: AxisTitles::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
AxisTitles::SelectAll()
{
    Select(ID_visible,   (void *)&visible);
    Select(ID_font,      (void *)&font);
    Select(ID_userTitle, (void *)&userTitle);
    Select(ID_userUnits, (void *)&userUnits);
    Select(ID_title,     (void *)&title);
    Select(ID_units,     (void *)&units);
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: AxisTitles::CreateNode
//
// Purpose: 
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
AxisTitles::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    AxisTitles defaultObject;
    bool addToParent = false;
    // Create a node for AxisTitles.
    DataNode *node = new DataNode("AxisTitles");

    if(completeSave || !FieldsEqual(ID_visible, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("visible", visible));
    }

    if(completeSave || !FieldsEqual(ID_font, &defaultObject))
    {
        DataNode *fontNode = new DataNode("font");
        if(font.CreateNode(fontNode, completeSave, false))
        {
            addToParent = true;
            node->AddNode(fontNode);
        }
        else
            delete fontNode;
    }

    if(completeSave || !FieldsEqual(ID_userTitle, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("userTitle", userTitle));
    }

    if(completeSave || !FieldsEqual(ID_userUnits, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("userUnits", userUnits));
    }

    if(completeSave || !FieldsEqual(ID_title, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("title", title));
    }

    if(completeSave || !FieldsEqual(ID_units, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("units", units));
    }


    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: AxisTitles::SetFromNode
//
// Purpose: 
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
AxisTitles::SetFromNode(DataNode *parentNode)
{
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("AxisTitles");
    if(searchNode == 0)
        return;

    DataNode *node;
    if((node = searchNode->GetNode("visible")) != 0)
        SetVisible(node->AsBool());
    if((node = searchNode->GetNode("font")) != 0)
        font.SetFromNode(node);
    if((node = searchNode->GetNode("userTitle")) != 0)
        SetUserTitle(node->AsBool());
    if((node = searchNode->GetNode("userUnits")) != 0)
        SetUserUnits(node->AsBool());
    if((node = searchNode->GetNode("title")) != 0)
        SetTitle(node->AsString());
    if((node = searchNode->GetNode("units")) != 0)
        SetUnits(node->AsString());
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
AxisTitles::SetVisible(bool visible_)
{
    visible = visible_;
    Select(ID_visible, (void *)&visible);
}

void
AxisTitles::SetFont(const FontAttributes &font_)
{
    font = font_;
    Select(ID_font, (void *)&font);
}

void
AxisTitles::SetUserTitle(bool userTitle_)
{
    userTitle = userTitle_;
    Select(ID_userTitle, (void *)&userTitle);
}

void
AxisTitles::SetUserUnits(bool userUnits_)
{
    userUnits = userUnits_;
    Select(ID_userUnits, (void *)&userUnits);
}

void
AxisTitles::SetTitle(const std::string &title_)
{
    title = title_;
    Select(ID_title, (void *)&title);
}

void
AxisTitles::SetUnits(const std::string &units_)
{
    units = units_;
    Select(ID_units, (void *)&units);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

bool
AxisTitles::GetVisible() const
{
    return visible;
}

const FontAttributes &
AxisTitles::GetFont() const
{
    return font;
}

FontAttributes &
AxisTitles::GetFont()
{
    return font;
}

bool
AxisTitles::GetUserTitle() const
{
    return userTitle;
}

bool
AxisTitles::GetUserUnits() const
{
    return userUnits;
}

const std::string &
AxisTitles::GetTitle() const
{
    return title;
}

std::string &
AxisTitles::GetTitle()
{
    return title;
}

const std::string &
AxisTitles::GetUnits() const
{
    return units;
}

std::string &
AxisTitles::GetUnits()
{
    return units;
}

///////////////////////////////////////////////////////////////////////////////
// Select property methods
///////////////////////////////////////////////////////////////////////////////

void
AxisTitles::SelectFont()
{
    Select(ID_font, (void *)&font);
}

void
AxisTitles::SelectTitle()
{
    Select(ID_title, (void *)&title);
}

void
AxisTitles::SelectUnits()
{
    Select(ID_units, (void *)&units);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: AxisTitles::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
AxisTitles::GetFieldName(int index) const
{
    switch (index)
    {
    case ID_visible:   return "visible";
    case ID_font:      return "font";
    case ID_userTitle: return "userTitle";
    case ID_userUnits: return "userUnits";
    case ID_title:     return "title";
    case ID_units:     return "units";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: AxisTitles::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
AxisTitles::GetFieldType(int index) const
{
    switch (index)
    {
    case ID_visible:   return FieldType_bool;
    case ID_font:      return FieldType_att;
    case ID_userTitle: return FieldType_bool;
    case ID_userUnits: return FieldType_bool;
    case ID_title:     return FieldType_string;
    case ID_units:     return FieldType_string;
    default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: AxisTitles::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
AxisTitles::GetFieldTypeName(int index) const
{
    switch (index)
    {
    case ID_visible:   return "bool";
    case ID_font:      return "att";
    case ID_userTitle: return "bool";
    case ID_userUnits: return "bool";
    case ID_title:     return "string";
    case ID_units:     return "string";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: AxisTitles::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
AxisTitles::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const AxisTitles &obj = *((const AxisTitles*)rhs);
    bool retval = false;
    switch (index_)
    {
    case ID_visible:
        {  // new scope
        retval = (visible == obj.visible);
        }
        break;
    case ID_font:
        {  // new scope
        retval = (font == obj.font);
        }
        break;
    case ID_userTitle:
        {  // new scope
        retval = (userTitle == obj.userTitle);
        }
        break;
    case ID_userUnits:
        {  // new scope
        retval = (userUnits == obj.userUnits);
        }
        break;
    case ID_title:
        {  // new scope
        retval = (title == obj.title);
        }
        break;
    case ID_units:
        {  // new scope
        retval = (units == obj.units);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

