/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes.hanim;

import java.util.HashMap;
import org.j3d.geom.hanim.HAnimFactory;
import org.j3d.geom.hanim.HAnimJoint;
import org.j3d.geom.hanim.HAnimObject;
import org.web3d.vrml.lang.FieldConstants;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLException;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLGroupingNodeType;
import org.web3d.vrml.nodes.VRMLHAnimNodeType;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLProtoInstance;
import org.web3d.vrml.renderer.common.nodes.BaseGroupingNode;
import org.web3d.vrml.renderer.common.nodes.hanim.BaseHAnimSegment;
import org.web3d.vrml.renderer.common.nodes.hanim.BaseHAnimSite;

public abstract class BaseHAnimJoint
extends BaseGroupingNode
implements VRMLHAnimNodeType {
    protected static final int FIELD_CENTER = 6;
    protected static final int FIELD_ROTATION = 7;
    protected static final int FIELD_SCALE = 8;
    protected static final int FIELD_SCALE_ORIENTATION = 9;
    protected static final int FIELD_TRANSLATION = 10;
    protected static final int FIELD_NAME = 11;
    protected static final int FIELD_LIMIT_ORIENTATION = 12;
    protected static final int FIELD_LLIMIT = 13;
    protected static final int FIELD_SKIN_COORD_INDEX = 14;
    protected static final int FIELD_SKIN_COORD_WEIGHT = 15;
    protected static final int FIELD_STIFFNESS = 16;
    protected static final int FIELD_ULIMIT = 17;
    protected static final int LAST_JOINT_INDEX = 17;
    protected static final int NUM_FIELDS = 18;
    private static final float ZEROEPS = 1.0E-4f;
    private static final String INVALID_CHILD_TYPE_MSG = "The child node added to a HAnimJoint must be one of HAnimJoint, HAnimSegment or HAnimSite";
    private static VRMLFieldDeclaration[] fieldDecl;
    private static HashMap fieldMap;
    private static int[] nodeFields;
    protected float[] vfCenter;
    protected float[] vfRotation;
    protected float[] vfScale;
    protected float[] vfScaleOrientation;
    protected float[] vfTranslation;
    protected String vfName;
    protected float[] vfLimitOrientation;
    protected float[] vfLlimit;
    protected int numLlimit;
    protected int[] vfSkinCoordIndex;
    protected int numSkinCoordIndex;
    protected float[] vfSkinCoordWeight;
    protected int numSkinCoordWeight;
    protected float[] vfStiffness;
    protected int numStiffness;
    protected float[] vfUlimit;
    protected int numUlimit;
    protected HAnimJoint hanimImpl;
    protected HAnimFactory hanimFactory;

    public BaseHAnimJoint() {
        super("HAnimJoint");
        this.hasChanged = new boolean[18];
        this.vfCenter = new float[]{0.0f, 0.0f, 0.0f};
        this.vfRotation = new float[]{0.0f, 0.0f, 1.0f, 0.0f};
        this.vfScale = new float[]{1.0f, 1.0f, 1.0f};
        this.vfScaleOrientation = new float[]{0.0f, 0.0f, 1.0f, 0.0f};
        this.vfTranslation = new float[]{0.0f, 0.0f, 0.0f};
        this.vfLimitOrientation = new float[]{0.0f, 0.0f, 1.0f, 0.0f};
        this.vfLlimit = FieldConstants.EMPTY_MFFLOAT;
        this.vfSkinCoordIndex = FieldConstants.EMPTY_MFINT32;
        this.vfSkinCoordWeight = FieldConstants.EMPTY_MFFLOAT;
        this.vfStiffness = new float[]{0.0f, 0.0f, 0.0f};
        this.vfUlimit = FieldConstants.EMPTY_MFFLOAT;
        this.numLlimit = 0;
        this.numSkinCoordIndex = 0;
        this.numSkinCoordWeight = 0;
        this.numStiffness = 3;
        this.numUlimit = 0;
    }

    public BaseHAnimJoint(VRMLNodeType vRMLNodeType) {
        this();
        this.checkNodeType(vRMLNodeType);
        this.copy((VRMLGroupingNodeType)vRMLNodeType);
        try {
            int n = vRMLNodeType.getFieldIndex("center");
            VRMLFieldData vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfCenter[0] = vRMLFieldData.floatArrayValue[0];
            this.vfCenter[1] = vRMLFieldData.floatArrayValue[1];
            this.vfCenter[2] = vRMLFieldData.floatArrayValue[2];
            n = vRMLNodeType.getFieldIndex("rotation");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfRotation[0] = vRMLFieldData.floatArrayValue[0];
            this.vfRotation[1] = vRMLFieldData.floatArrayValue[1];
            this.vfRotation[2] = vRMLFieldData.floatArrayValue[2];
            this.vfRotation[3] = vRMLFieldData.floatArrayValue[3];
            n = vRMLNodeType.getFieldIndex("scale");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfScale[0] = vRMLFieldData.floatArrayValue[0];
            this.vfScale[1] = vRMLFieldData.floatArrayValue[1];
            this.vfScale[2] = vRMLFieldData.floatArrayValue[2];
            n = vRMLNodeType.getFieldIndex("scaleOrientation");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfScaleOrientation[0] = vRMLFieldData.floatArrayValue[0];
            this.vfScaleOrientation[1] = vRMLFieldData.floatArrayValue[1];
            this.vfScaleOrientation[2] = vRMLFieldData.floatArrayValue[2];
            this.vfScaleOrientation[3] = vRMLFieldData.floatArrayValue[3];
            n = vRMLNodeType.getFieldIndex("translation");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfTranslation[0] = vRMLFieldData.floatArrayValue[0];
            this.vfTranslation[1] = vRMLFieldData.floatArrayValue[1];
            this.vfTranslation[2] = vRMLFieldData.floatArrayValue[2];
            n = vRMLNodeType.getFieldIndex("name");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfName = vRMLFieldData.stringValue;
            n = vRMLNodeType.getFieldIndex("limitOrientation");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfLimitOrientation[0] = vRMLFieldData.floatArrayValue[0];
            this.vfLimitOrientation[1] = vRMLFieldData.floatArrayValue[1];
            this.vfLimitOrientation[2] = vRMLFieldData.floatArrayValue[2];
            this.vfLimitOrientation[3] = vRMLFieldData.floatArrayValue[3];
            n = vRMLNodeType.getFieldIndex("limit");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            if (this.vfLlimit.length < vRMLFieldData.numElements) {
                this.vfLlimit = new float[vRMLFieldData.numElements];
            }
            System.arraycopy(vRMLFieldData.floatArrayValue, 0, this.vfLlimit, 0, vRMLFieldData.numElements);
            this.numLlimit = vRMLFieldData.numElements;
            n = vRMLNodeType.getFieldIndex("skinCoordIndex");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            if (this.vfSkinCoordIndex.length < vRMLFieldData.numElements) {
                this.vfSkinCoordIndex = new int[vRMLFieldData.numElements];
            }
            System.arraycopy(vRMLFieldData.intArrayValue, 0, this.vfSkinCoordIndex, 0, vRMLFieldData.numElements);
            this.numSkinCoordIndex = vRMLFieldData.numElements;
            n = vRMLNodeType.getFieldIndex("skinCoordWeight");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            if (this.vfSkinCoordWeight.length < vRMLFieldData.numElements) {
                this.vfSkinCoordWeight = new float[vRMLFieldData.numElements];
            }
            System.arraycopy(vRMLFieldData.floatArrayValue, 0, this.vfSkinCoordWeight, 0, vRMLFieldData.numElements);
            this.numSkinCoordWeight = vRMLFieldData.numElements;
            n = vRMLNodeType.getFieldIndex("stiffness");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            if (this.vfStiffness.length < vRMLFieldData.numElements) {
                this.vfStiffness = new float[vRMLFieldData.numElements];
            }
            System.arraycopy(vRMLFieldData.floatArrayValue, 0, this.vfStiffness, 0, vRMLFieldData.numElements);
            this.numStiffness = vRMLFieldData.numElements;
            n = vRMLNodeType.getFieldIndex("ulimit");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            if (this.vfUlimit.length < vRMLFieldData.numElements) {
                this.vfUlimit = new float[vRMLFieldData.numElements];
            }
            System.arraycopy(vRMLFieldData.floatArrayValue, 0, this.vfUlimit, 0, vRMLFieldData.numElements);
            this.numUlimit = vRMLFieldData.numElements;
        }
        catch (VRMLException vRMLException) {
            throw new IllegalArgumentException(vRMLException.getMessage());
        }
    }

    public void setHAnimFactory(HAnimFactory hAnimFactory) {
        this.hanimFactory = hAnimFactory;
        int n = this.vfChildren.size();
        for (int i = 0; i < n; ++i) {
            VRMLHAnimNodeType vRMLHAnimNodeType = (VRMLHAnimNodeType)this.vfChildren.get(i);
            vRMLHAnimNodeType.setHAnimFactory(hAnimFactory);
        }
        this.hanimImpl = hAnimFactory.createJoint();
        this.hanimImpl.setName(this.vfName);
        this.hanimImpl.setCenter(this.vfCenter);
        this.hanimImpl.setScale(this.vfScale);
        this.hanimImpl.setRotation(this.vfRotation);
        this.hanimImpl.setTranslation(this.vfTranslation);
        this.hanimImpl.setScaleOrientation(this.vfScaleOrientation);
        this.hanimImpl.setLimitOrientation(this.vfLimitOrientation);
        this.hanimImpl.setLowerLimit(this.vfLlimit, this.numLlimit);
        this.hanimImpl.setUpperLimit(this.vfUlimit, this.numUlimit);
        this.hanimImpl.setSkinCoordIndex(this.vfSkinCoordIndex, this.numSkinCoordIndex);
        this.hanimImpl.setSkinCoordWeight(this.vfSkinCoordWeight);
        this.hanimImpl.setStiffness(this.vfStiffness, this.numStiffness);
        this.hanimImpl.setBboxCenter(this.vfBboxCenter);
        this.hanimImpl.setBboxSize(this.vfBboxSize);
        HAnimObject[] hAnimObjectArray = new HAnimObject[n];
        for (int i = 0; i < n; ++i) {
            VRMLHAnimNodeType vRMLHAnimNodeType = (VRMLHAnimNodeType)this.vfChildren.get(i);
            hAnimObjectArray[i] = vRMLHAnimNodeType.getHAnimObject();
        }
        this.hanimImpl.setChildren(hAnimObjectArray, n);
    }

    public HAnimObject getHAnimObject() {
        return this.hanimImpl;
    }

    public int getFieldIndex(String string) {
        Integer n = (Integer)fieldMap.get(string);
        return n == null ? -1 : n;
    }

    public int[] getNodeFieldIndices() {
        return nodeFields;
    }

    public VRMLFieldDeclaration getFieldDeclaration(int n) {
        if (n < 0 || n > 17) {
            return null;
        }
        return fieldDecl[n];
    }

    public int getNumFields() {
        return fieldDecl.length;
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        VRMLFieldData vRMLFieldData = (VRMLFieldData)this.fieldLocalData.get();
        vRMLFieldData.clear();
        vRMLFieldData.dataType = (short)11;
        switch (n) {
            case 6: {
                vRMLFieldData.floatArrayValue = this.vfCenter;
                vRMLFieldData.numElements = 1;
                break;
            }
            case 7: {
                vRMLFieldData.floatArrayValue = this.vfRotation;
                vRMLFieldData.numElements = 1;
                break;
            }
            case 8: {
                vRMLFieldData.floatArrayValue = this.vfScale;
                vRMLFieldData.numElements = 1;
                break;
            }
            case 9: {
                vRMLFieldData.floatArrayValue = this.vfScaleOrientation;
                vRMLFieldData.numElements = 1;
                break;
            }
            case 10: {
                vRMLFieldData.floatArrayValue = this.vfTranslation;
                vRMLFieldData.numElements = 1;
                break;
            }
            case 11: {
                vRMLFieldData.stringValue = this.vfName;
                vRMLFieldData.dataType = (short)6;
                break;
            }
            case 12: {
                vRMLFieldData.floatArrayValue = this.vfLimitOrientation;
                vRMLFieldData.numElements = 1;
                break;
            }
            case 13: {
                vRMLFieldData.floatArrayValue = this.vfLlimit;
                vRMLFieldData.numElements = this.numLlimit;
                break;
            }
            case 14: {
                vRMLFieldData.intArrayValue = this.vfSkinCoordIndex;
                vRMLFieldData.numElements = this.numSkinCoordIndex;
                vRMLFieldData.dataType = (short)9;
                break;
            }
            case 15: {
                vRMLFieldData.floatArrayValue = this.vfSkinCoordWeight;
                vRMLFieldData.numElements = this.numSkinCoordWeight;
                break;
            }
            case 16: {
                vRMLFieldData.floatArrayValue = this.vfStiffness;
                vRMLFieldData.numElements = this.numStiffness;
                break;
            }
            case 17: {
                vRMLFieldData.floatArrayValue = this.vfUlimit;
                vRMLFieldData.numElements = this.numUlimit;
                break;
            }
            default: {
                super.getFieldValue(n);
            }
        }
        return vRMLFieldData;
    }

    public void sendRoute(double d, int n, VRMLNodeType vRMLNodeType, int n2) {
        try {
            switch (n) {
                case 6: {
                    vRMLNodeType.setValue(n2, this.vfCenter, 3);
                    break;
                }
                case 7: {
                    vRMLNodeType.setValue(n2, this.vfRotation, 4);
                    break;
                }
                case 8: {
                    vRMLNodeType.setValue(n2, this.vfScale, 3);
                    break;
                }
                case 9: {
                    vRMLNodeType.setValue(n2, this.vfScaleOrientation, 4);
                    break;
                }
                case 10: {
                    vRMLNodeType.setValue(n2, this.vfTranslation, 3);
                    break;
                }
                case 11: {
                    vRMLNodeType.setValue(n2, this.vfName);
                    break;
                }
                case 12: {
                    vRMLNodeType.setValue(n2, this.vfLimitOrientation, 4);
                    break;
                }
                case 13: {
                    vRMLNodeType.setValue(n2, this.vfLlimit, this.numLlimit);
                    break;
                }
                case 14: {
                    vRMLNodeType.setValue(n2, this.vfSkinCoordIndex, this.numSkinCoordIndex);
                    break;
                }
                case 15: {
                    vRMLNodeType.setValue(n2, this.vfSkinCoordWeight, this.numSkinCoordWeight);
                    break;
                }
                case 16: {
                    vRMLNodeType.setValue(n2, this.vfStiffness, this.numStiffness);
                    break;
                }
                case 17: {
                    vRMLNodeType.setValue(n2, this.vfUlimit, this.numUlimit);
                    break;
                }
                default: {
                    super.sendRoute(d, n, vRMLNodeType, n2);
                    break;
                }
            }
        }
        catch (InvalidFieldException invalidFieldException) {
            System.err.println("BaseHAnimJoint.sendRoute: No field!" + n);
            invalidFieldException.printStackTrace();
        }
        catch (InvalidFieldValueException invalidFieldValueException) {
            System.err.println("sendRoute: Invalid fieldValue: " + invalidFieldValueException.getMessage());
        }
    }

    public void setValue(int n, int[] nArray, int n2) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 14: {
                this.setSkinCoordIndex(nArray, n2);
                break;
            }
            default: {
                super.setValue(n, nArray, n2);
            }
        }
    }

    public void setValue(int n, float[] fArray, int n2) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 6: {
                this.setCenter(fArray);
                break;
            }
            case 7: {
                this.setRotation(fArray);
                break;
            }
            case 8: {
                this.setScale(fArray);
                break;
            }
            case 9: {
                this.setScaleOrientation(fArray);
                break;
            }
            case 10: {
                this.setTranslation(fArray);
                break;
            }
            case 12: {
                this.setLimitOrientation(fArray);
                break;
            }
            case 13: {
                this.setLlimit(fArray, n2);
                break;
            }
            case 15: {
                this.setSkinCoordWeight(fArray, n2);
                break;
            }
            case 16: {
                this.setStiffness(fArray, n2);
                break;
            }
            case 17: {
                this.setUlimit(fArray, n2);
                break;
            }
            default: {
                super.setValue(n, fArray, n2);
            }
        }
    }

    public void setValue(int n, String string) throws InvalidFieldException {
        switch (n) {
            case 11: {
                this.vfName = string;
                if (this.inSetup) break;
                this.hanimImpl.setName(this.vfName);
                this.hasChanged[11] = true;
                this.fireFieldChanged(11);
                break;
            }
            default: {
                super.setValue(n, string);
            }
        }
    }

    protected void clearChildren() {
        super.clearChildren();
        this.hanimImpl.setChildren(null, 0);
    }

    protected void addChildNode(VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
        boolean bl = false;
        if (vRMLNodeType instanceof BaseHAnimJoint || vRMLNodeType instanceof BaseHAnimSegment || vRMLNodeType instanceof BaseHAnimSite) {
            bl = true;
            if (!this.inSetup) {
                VRMLHAnimNodeType vRMLHAnimNodeType = (VRMLHAnimNodeType)vRMLNodeType;
                HAnimObject hAnimObject = vRMLHAnimNodeType.getHAnimObject();
                this.hanimImpl.addChild(hAnimObject);
            }
        } else if (vRMLNodeType instanceof VRMLProtoInstance) {
            VRMLNodeType vRMLNodeType2 = ((VRMLProtoInstance)vRMLNodeType).getImplementationNode();
            while (vRMLNodeType2 != null && vRMLNodeType2 instanceof VRMLProtoInstance) {
                vRMLNodeType2 = ((VRMLProtoInstance)vRMLNodeType2).getImplementationNode();
            }
            if (vRMLNodeType2 == null || vRMLNodeType2 instanceof BaseHAnimJoint || vRMLNodeType2 instanceof BaseHAnimSegment || vRMLNodeType2 instanceof BaseHAnimSite) {
                bl = true;
            }
            if (!this.inSetup && bl && vRMLNodeType2 != null) {
                VRMLHAnimNodeType vRMLHAnimNodeType = (VRMLHAnimNodeType)vRMLNodeType2;
                HAnimObject hAnimObject = vRMLHAnimNodeType.getHAnimObject();
                this.hanimImpl.addChild(hAnimObject);
            }
        }
        if (!bl) {
            throw new InvalidFieldValueException(INVALID_CHILD_TYPE_MSG);
        }
        super.addChildNode(vRMLNodeType);
    }

    protected void removeChildNode(VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
        boolean bl = false;
        if (vRMLNodeType instanceof BaseHAnimJoint || vRMLNodeType instanceof BaseHAnimSegment || vRMLNodeType instanceof BaseHAnimSite) {
            bl = true;
            VRMLHAnimNodeType vRMLHAnimNodeType = (VRMLHAnimNodeType)vRMLNodeType;
            HAnimObject hAnimObject = vRMLHAnimNodeType.getHAnimObject();
            this.hanimImpl.removeChild(hAnimObject);
        } else if (vRMLNodeType instanceof VRMLProtoInstance) {
            VRMLNodeType vRMLNodeType2 = ((VRMLProtoInstance)vRMLNodeType).getImplementationNode();
            while (vRMLNodeType2 != null && vRMLNodeType2 instanceof VRMLProtoInstance) {
                vRMLNodeType2 = ((VRMLProtoInstance)vRMLNodeType2).getImplementationNode();
            }
            if (vRMLNodeType2 == null || vRMLNodeType2 instanceof BaseHAnimJoint || vRMLNodeType2 instanceof BaseHAnimSegment || vRMLNodeType2 instanceof BaseHAnimSite) {
                bl = true;
            }
            if (bl && vRMLNodeType2 != null) {
                VRMLHAnimNodeType vRMLHAnimNodeType = (VRMLHAnimNodeType)vRMLNodeType;
                HAnimObject hAnimObject = vRMLHAnimNodeType.getHAnimObject();
                this.hanimImpl.removeChild(hAnimObject);
            }
        }
        if (!bl) {
            throw new InvalidFieldValueException(INVALID_CHILD_TYPE_MSG);
        }
        super.removeChildNode(vRMLNodeType);
    }

    protected void setRotation(float[] fArray) throws InvalidFieldValueException {
        if (fArray == null) {
            throw new InvalidFieldValueException("Rotation value null");
        }
        this.vfRotation[0] = fArray[0];
        this.vfRotation[1] = fArray[1];
        this.vfRotation[2] = fArray[2];
        this.vfRotation[3] = fArray[3];
        if (!this.inSetup) {
            this.hanimImpl.setRotation(this.vfRotation);
            this.hasChanged[7] = true;
            this.fireFieldChanged(7);
        }
    }

    protected void setTranslation(float[] fArray) throws InvalidFieldValueException {
        if (fArray == null) {
            throw new InvalidFieldValueException("Translation value null");
        }
        this.vfTranslation[0] = fArray[0];
        this.vfTranslation[1] = fArray[1];
        this.vfTranslation[2] = fArray[2];
        if (!this.inSetup) {
            this.hanimImpl.setTranslation(this.vfTranslation);
            this.hasChanged[10] = true;
            this.fireFieldChanged(10);
        }
    }

    protected void setScale(float[] fArray) throws InvalidFieldValueException {
        if (fArray == null) {
            throw new InvalidFieldValueException("Scale value null");
        }
        this.vfScale[0] = fArray[0];
        this.vfScale[1] = fArray[1];
        this.vfScale[2] = fArray[2];
        if (!this.inSetup) {
            this.hanimImpl.setScale(this.vfScale);
            this.hasChanged[8] = true;
            this.fireFieldChanged(8);
        }
    }

    protected void setScaleOrientation(float[] fArray) throws InvalidFieldValueException {
        if (fArray == null) {
            throw new InvalidFieldValueException("Scale Orientation value null");
        }
        this.vfScaleOrientation[0] = fArray[0];
        this.vfScaleOrientation[1] = fArray[1];
        this.vfScaleOrientation[2] = fArray[2];
        this.vfScaleOrientation[3] = fArray[3];
        if (!this.inSetup) {
            this.hanimImpl.setScaleOrientation(this.vfScaleOrientation);
            this.hasChanged[9] = true;
            this.fireFieldChanged(9);
        }
    }

    protected void setCenter(float[] fArray) throws InvalidFieldValueException {
        if (fArray == null) {
            throw new InvalidFieldValueException("Center value null");
        }
        this.vfCenter[0] = fArray[0];
        this.vfCenter[1] = fArray[1];
        this.vfCenter[2] = fArray[2];
        if (!this.inSetup) {
            this.hanimImpl.setCenter(this.vfCenter);
            this.hasChanged[6] = true;
            this.fireFieldChanged(6);
        }
    }

    protected void setLimitOrientation(float[] fArray) throws InvalidFieldValueException {
        if (fArray == null) {
            throw new InvalidFieldValueException("Limit Orientation value null");
        }
        this.vfLimitOrientation[0] = fArray[0];
        this.vfLimitOrientation[1] = fArray[1];
        this.vfLimitOrientation[2] = fArray[2];
        this.vfLimitOrientation[3] = fArray[3];
        if (!this.inSetup) {
            this.hanimImpl.setLimitOrientation(this.vfLimitOrientation);
            this.hasChanged[12] = true;
            this.fireFieldChanged(12);
        }
    }

    protected void setLlimit(float[] fArray, int n) throws InvalidFieldValueException {
        if (fArray == null) {
            throw new InvalidFieldValueException("Limit value null");
        }
        if (this.vfLlimit.length < n) {
            this.vfLlimit = new float[n];
        }
        System.arraycopy(fArray, 0, this.vfLlimit, 0, n);
        this.numLlimit = n;
        if (!this.inSetup) {
            this.hanimImpl.setLowerLimit(this.vfLlimit, this.numLlimit);
            this.hasChanged[13] = true;
            this.fireFieldChanged(13);
        }
    }

    protected void setSkinCoordIndex(int[] nArray, int n) throws InvalidFieldValueException {
        if (nArray == null) {
            throw new InvalidFieldValueException("skinCoordIndex value null");
        }
        if (this.vfSkinCoordIndex.length < n) {
            this.vfSkinCoordIndex = new int[n];
        }
        System.arraycopy(nArray, 0, this.vfSkinCoordIndex, 0, n);
        this.numSkinCoordIndex = n;
        if (!this.inSetup) {
            this.hanimImpl.setSkinCoordIndex(this.vfSkinCoordIndex, this.numSkinCoordIndex);
            this.hasChanged[14] = true;
            this.fireFieldChanged(14);
        }
    }

    protected void setSkinCoordWeight(float[] fArray, int n) throws InvalidFieldValueException {
        if (fArray == null) {
            throw new InvalidFieldValueException("skinCoordWeight value null");
        }
        if (this.vfSkinCoordWeight.length < n) {
            this.vfSkinCoordWeight = new float[n];
        }
        System.arraycopy(fArray, 0, this.vfSkinCoordWeight, 0, n);
        this.numSkinCoordWeight = n;
        if (!this.inSetup) {
            this.hanimImpl.setSkinCoordWeight(this.vfSkinCoordWeight);
            this.hasChanged[15] = true;
            this.fireFieldChanged(15);
        }
    }

    protected void setStiffness(float[] fArray, int n) throws InvalidFieldValueException {
        if (fArray == null) {
            throw new InvalidFieldValueException("Stiffness value null");
        }
        for (int i = 0; i < n; ++i) {
            if (!(fArray[i] < 0.0f) && !(fArray[i] > 1.0f)) continue;
            throw new InvalidFieldValueException("Stiffness value at " + i + " is outside the legal range of [0, 1]");
        }
        if (this.vfStiffness.length < n) {
            this.vfStiffness = new float[n];
        }
        System.arraycopy(fArray, 0, this.vfStiffness, 0, n);
        this.numStiffness = n;
        if (!this.inSetup) {
            this.hanimImpl.setStiffness(this.vfStiffness, this.numStiffness);
            this.hasChanged[16] = true;
            this.fireFieldChanged(16);
        }
    }

    protected void setUlimit(float[] fArray, int n) throws InvalidFieldValueException {
        if (fArray == null) {
            throw new InvalidFieldValueException("Limit value null");
        }
        if (this.vfUlimit.length < n) {
            this.vfUlimit = new float[n];
        }
        System.arraycopy(fArray, 0, this.vfUlimit, 0, n);
        this.numUlimit = n;
        if (!this.inSetup) {
            this.hanimImpl.setUpperLimit(this.vfUlimit, this.numUlimit);
            this.hasChanged[17] = true;
            this.fireFieldChanged(17);
        }
    }

    static {
        nodeFields = new int[]{1, 0};
        fieldDecl = new VRMLFieldDeclaration[18];
        fieldMap = new HashMap(18);
        BaseHAnimJoint.fieldDecl[0] = new VRMLFieldDeclaration(3, "SFNode", "metadata");
        BaseHAnimJoint.fieldDecl[1] = new VRMLFieldDeclaration(3, "MFNode", "children");
        BaseHAnimJoint.fieldDecl[2] = new VRMLFieldDeclaration(1, "MFNode", "addChildren");
        BaseHAnimJoint.fieldDecl[3] = new VRMLFieldDeclaration(1, "MFNode", "removeChildren");
        BaseHAnimJoint.fieldDecl[4] = new VRMLFieldDeclaration(2, "SFVec3f", "bboxCenter");
        BaseHAnimJoint.fieldDecl[5] = new VRMLFieldDeclaration(2, "SFVec3f", "bboxSize");
        BaseHAnimJoint.fieldDecl[6] = new VRMLFieldDeclaration(3, "SFVec3f", "center");
        BaseHAnimJoint.fieldDecl[7] = new VRMLFieldDeclaration(3, "SFRotation", "rotation");
        BaseHAnimJoint.fieldDecl[8] = new VRMLFieldDeclaration(3, "SFVec3f", "scale");
        BaseHAnimJoint.fieldDecl[9] = new VRMLFieldDeclaration(3, "SFRotation", "scaleOrientation");
        BaseHAnimJoint.fieldDecl[10] = new VRMLFieldDeclaration(3, "SFVec3f", "translation");
        BaseHAnimJoint.fieldDecl[11] = new VRMLFieldDeclaration(3, "SFString", "name");
        BaseHAnimJoint.fieldDecl[12] = new VRMLFieldDeclaration(3, "SFRotation", "limitOrientation");
        BaseHAnimJoint.fieldDecl[13] = new VRMLFieldDeclaration(3, "MFFloat", "llimit");
        BaseHAnimJoint.fieldDecl[14] = new VRMLFieldDeclaration(3, "MFInt32", "skinCoordIndex");
        BaseHAnimJoint.fieldDecl[15] = new VRMLFieldDeclaration(3, "MFFloat", "skinCoordWeight");
        BaseHAnimJoint.fieldDecl[16] = new VRMLFieldDeclaration(3, "MFFloat", "stiffness");
        BaseHAnimJoint.fieldDecl[17] = new VRMLFieldDeclaration(3, "MFFloat", "ulimit");
        Integer n = new Integer(0);
        fieldMap.put("metadata", n);
        fieldMap.put("set_metadata", n);
        fieldMap.put("metadata_changed", n);
        n = new Integer(1);
        fieldMap.put("children", n);
        fieldMap.put("set_children", n);
        fieldMap.put("children_changed", n);
        n = new Integer(2);
        fieldMap.put("addChildren", n);
        fieldMap.put("set_addChildren", n);
        n = new Integer(3);
        fieldMap.put("removeChildren", n);
        fieldMap.put("set_removeChildren", n);
        fieldMap.put("bboxCenter", new Integer(4));
        fieldMap.put("bboxSize", new Integer(5));
        n = new Integer(6);
        fieldMap.put("center", n);
        fieldMap.put("set_center", n);
        fieldMap.put("center_changed", n);
        n = new Integer(7);
        fieldMap.put("rotation", n);
        fieldMap.put("set_rotation", n);
        fieldMap.put("rotation_changed", n);
        n = new Integer(8);
        fieldMap.put("scale", n);
        fieldMap.put("set_scale", n);
        fieldMap.put("scale_changed", n);
        n = new Integer(9);
        fieldMap.put("scaleOrientation", n);
        fieldMap.put("set_scaleOrientation", n);
        fieldMap.put("scaleOrientation_changed", n);
        n = new Integer(10);
        fieldMap.put("translation", n);
        fieldMap.put("set_translation", n);
        fieldMap.put("translation_changed", n);
        n = new Integer(11);
        fieldMap.put("name", n);
        fieldMap.put("set_name", n);
        fieldMap.put("name_changed", n);
        n = new Integer(12);
        fieldMap.put("limitOrientation", n);
        fieldMap.put("set_limitOrientation", n);
        fieldMap.put("limitOrientation_changed", n);
        n = new Integer(13);
        fieldMap.put("llimit", n);
        fieldMap.put("set_llimit", n);
        fieldMap.put("llimit_changed", n);
        n = new Integer(14);
        fieldMap.put("skinCoordIndex", n);
        fieldMap.put("set_skinCoordIndex", n);
        fieldMap.put("skinCoordIndex_changed", n);
        n = new Integer(15);
        fieldMap.put("skinCoordWeight", n);
        fieldMap.put("set_skinCoordWeight", n);
        fieldMap.put("skinCoordWeight_changed", n);
        n = new Integer(16);
        fieldMap.put("stiffness", n);
        fieldMap.put("set_stiffness", n);
        fieldMap.put("stiffness_changed", n);
        n = new Integer(17);
        fieldMap.put("ulimit", n);
        fieldMap.put("set_ulimit", n);
        fieldMap.put("ulimit_changed", n);
    }
}

