/*
 * Copyright (c) 2010, 2013, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/**
 * NASHORN-378 : Redefining a configurable accessor property to be a data property on a non-extensible object fails with NPE
 *
 * @test
 * @run
 */

var obj = {};
Object.defineProperty(obj, "foo",
    { get: function() { return 42; },
      configurable: true});

if (obj.foo !== 42) {
    fail("#0 obj.foo !== 42");
}

Object.preventExtensions(obj);
Object.defineProperty(obj, "foo", { value: "hello"});

var desc = Object.getOwnPropertyDescriptor(obj, "foo");

if (obj.foo !== "hello") {
    fail("#1 obj.foo !== 'hello'");
}

if (desc.get !== undefined) {
    fail("#2 getter found on a date property");
}

if (desc.set !== undefined) {
    fail("#3 setter found on a date property");
}

if (desc.value !== 'hello') {
    fail("#4 value property is wrong");
}
