#!/usr/bin/env python3

import importlib.util
import os

from fenrirscreenreader.core.i18n import _

# Load base configuration class
_base_path = os.path.join(os.path.dirname(__file__), "..", "config_base.py")
_spec = importlib.util.spec_from_file_location("config_base", _base_path)
_module = importlib.util.module_from_spec(_spec)
_spec.loader.exec_module(_module)
config_command = _module.config_command


class command(config_command):
    def __init__(self):
        super().__init__()

    def get_description(self):
        return "Toggle word echo when pressing space"

    def run(self):
        current_state = self.getBooleanSetting("keyboard", "wordEcho", False)
        new_state = self.toggleBooleanSetting("keyboard", "wordEcho")

        if new_state != current_state:
            state_text = "enabled" if new_state else "disabled"
            self.present_text(f"Word echo {state_text}")
            if new_state:
                self.present_text("Words will be spoken when you press space")
            else:
                self.present_text(
                    "Words will not be spoken when you press space"
                )
            self.play_sound("Accept")
        else:
            self.present_text("Failed to change word echo setting")
            self.play_sound("Error")
