#!/bin/sh

if test "$#" -lt 3
then
	echo >&2 "usage: $0 <BUILD_DIR> <BUILD_OPTIONS> <LIBFILE> [<LIBFILE>...]"
	exit 1
fi

BUILD_DIR="$1"
BUILD_OPTIONS="$2"
shift 2
LIBFILES="$(echo "$@" | sort | sed 's|lib/||g')"

. "$BUILD_OPTIONS"

cd "$BUILD_DIR"

if {
	echo "source lib/class.tcl;"
	echo "auto_mkindex lib $LIBFILES"
} | "$TCL_PATH"
then
	: ok
else
	 echo >&2 "    * $TCL_PATH failed; using unoptimized loading"
	 rm -f lib/tclIndex
	 echo '# Autogenerated by git-gui Makefile' >lib/tclIndex
	 echo >>lib/tclIndex
	 echo "class.tcl" >>lib/tclIndex
	 printf "%s\n" $LIBFILES >>lib/tclIndex
	 echo >>lib/tclIndex
fi
