/* SPDX-License-Identifier: GPL-2.0 */
/*
 * Copyright (C) 2024, Intel Corporation
 */

#ifndef __AGILEX5_CLOCK_H
#define __AGILEX5_CLOCK_H

/* fixed rate clocks */
#define AGILEX5_OSC1			0
#define AGILEX5_CB_INTOSC_HS_DIV2_CLK	1
#define AGILEX5_CB_INTOSC_LS_CLK		2
#define AGILEX5_L4_SYS_FREE_CLK		3
#define AGILEX5_F2S_FREE_CLK		4

/* PLL clocks */
#define AGILEX5_MAIN_PLL_CLK		5
#define AGILEX5_MAIN_PLL_C0_CLK		6
#define AGILEX5_MAIN_PLL_C1_CLK		7
#define AGILEX5_MAIN_PLL_C2_CLK		8
#define AGILEX5_MAIN_PLL_C3_CLK		9
#define AGILEX5_PERIPH_PLL_CLK		10
#define AGILEX5_PERIPH_PLL_C0_CLK	11
#define AGILEX5_PERIPH_PLL_C1_CLK	12
#define AGILEX5_PERIPH_PLL_C2_CLK	13
#define AGILEX5_PERIPH_PLL_C3_CLK	14
#define AGILEX5_MPU_FREE_CLK		15
#define AGILEX5_MPU_CCU_CLK		16
#define AGILEX5_BOOT_CLK			17

/* fixed factor clocks */
#define AGILEX5_L3_MAIN_FREE_CLK		18
#define AGILEX5_NOC_FREE_CLK		19
#define AGILEX5_S2F_USR0_CLK		20
#define AGILEX5_NOC_CLK			21
#define AGILEX5_EMAC_A_FREE_CLK		22
#define AGILEX5_EMAC_B_FREE_CLK		23
#define AGILEX5_EMAC_PTP_FREE_CLK	24
#define AGILEX5_GPIO_DB_FREE_CLK		25
#define AGILEX5_SDMMC_FREE_CLK		26
#define AGILEX5_S2F_USER0_FREE_CLK	27
#define AGILEX5_S2F_USER1_FREE_CLK	28
#define AGILEX5_PSI_REF_FREE_CLK		29

/* Gate clocks */
#define AGILEX5_MPU_CLK			30
#define AGILEX5_MPU_PERIPH_CLK		31
#define AGILEX5_L4_MAIN_CLK		32
#define AGILEX5_L4_MP_CLK		33
#define AGILEX5_L4_SP_CLK		34
#define AGILEX5_CS_AT_CLK		35
#define AGILEX5_CS_TRACE_CLK		36
#define AGILEX5_CS_PDBG_CLK		37
#define AGILEX5_CS_TIMER_CLK		38
#define AGILEX5_S2F_USER0_CLK		39
#define AGILEX5_EMAC0_CLK		40
#define AGILEX5_EMAC1_CLK		41
#define AGILEX5_EMAC2_CLK		42
#define AGILEX5_EMAC_PTP_CLK		43
#define AGILEX5_GPIO_DB_CLK		44
#define AGILEX5_NAND_CLK			45
#define AGILEX5_PSI_REF_CLK		46
#define AGILEX5_S2F_USER1_CLK		47
#define AGILEX5_SDMMC_CLK		48
#define AGILEX5_SPI_M_CLK		49
#define AGILEX5_USB_CLK			50
#define AGILEX5_NAND_X_CLK		51
#define AGILEX5_NAND_ECC_CLK		52
#define AGILEX5_NUM_CLKS			53

#endif	/* __AGILEX5_CLOCK_H */
